/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.docker.tree.impl;

import java.util.ArrayList;
import java.util.List;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.docker.tree.api.DockerTree;
import org.sonar.iac.docker.tree.api.ExecFormLiteralTree;
import org.sonar.iac.docker.tree.api.ExecFormTree;
import org.sonar.iac.docker.tree.api.LiteralListTree;
import org.sonar.iac.docker.tree.api.SeparatedList;
import org.sonar.iac.docker.tree.api.SyntaxToken;
import org.sonar.iac.docker.tree.impl.DockerTreeImpl;

public class ExecFormTreeImpl
extends DockerTreeImpl
implements ExecFormTree {
    private final SyntaxToken leftBracket;
    private final SeparatedList<ExecFormLiteralTree> literalsWithSeparators;
    private final SyntaxToken rightBracket;

    public ExecFormTreeImpl(SyntaxToken leftBracket, SeparatedList<ExecFormLiteralTree> literals, SyntaxToken rightBracket) {
        this.leftBracket = leftBracket;
        this.literalsWithSeparators = literals;
        this.rightBracket = rightBracket;
    }

    @Override
    public List<Tree> children() {
        ArrayList<Tree> result = new ArrayList<Tree>();
        result.add(this.leftBracket);
        result.addAll(this.literalsWithSeparators.elementsAndSeparators());
        result.add(this.rightBracket);
        return result;
    }

    @Override
    public DockerTree.Kind getKind() {
        return DockerTree.Kind.EXEC_FORM;
    }

    @Override
    public SyntaxToken leftBracket() {
        return this.leftBracket;
    }

    @Override
    public List<SyntaxToken> literals() {
        ArrayList<SyntaxToken> result = new ArrayList<SyntaxToken>();
        for (ExecFormLiteralTree element : this.literalsWithSeparators.elements()) {
            result.add(element.value());
        }
        return result;
    }

    @Override
    public LiteralListTree.LiteralListType type() {
        return LiteralListTree.LiteralListType.EXEC;
    }

    @Override
    public SeparatedList<ExecFormLiteralTree> literalsWithSeparators() {
        return this.literalsWithSeparators;
    }

    @Override
    public SyntaxToken rightBracket() {
        return this.rightBracket;
    }
}

