/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.terraform.api.tree.AttributeTree;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;

@Rule(key="S6333")
public class PublicApiCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure creating a public API is safe here.";

    @Override
    protected void registerResourceChecks() {
        this.register(PublicApiCheck::checkApiGatewayMethod, "aws_api_gateway_method");
    }

    private static void checkApiGatewayMethod(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get(resource, "authorization", AttributeTree.class).ifPresent(authorization -> PublicApiCheck.reportSensitiveValue(ctx, authorization, "NONE", MESSAGE, new SecondaryLocation(resource.labels().get(0), "Related method")));
    }
}

