/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.utils.ExpressionPredicate;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

@Rule(key="S6275")
public class UnencryptedEbsVolumeCheck
extends AbstractNewResourceCheck {
    private static final List<String> PROPERTIES = List.of("root_block_device", "ebs_block_device");
    private static final String MESSAGE = "Make sure that using unencrypted volumes is safe here.";
    private static final String OMITTING_MESSAGE = "Omitting \"%s\" disables volumes encryption. Make sure it is safe here.";

    @Override
    protected void registerResourceConsumer() {
        this.register("aws_ebs_encryption_by_default", (ResourceSymbol resource) -> resource.attribute("enabled").reportIf(ExpressionPredicate.isFalse(), MESSAGE, new SecondaryLocation[0]));
        this.register("aws_ebs_volume", (ResourceSymbol resource) -> resource.attribute("encrypted").reportIfAbsent(OMITTING_MESSAGE, new SecondaryLocation[0]).reportIf(ExpressionPredicate.isFalse(), MESSAGE, new SecondaryLocation[0]));
        this.register("aws_launch_configuration", (ResourceSymbol resource) -> PROPERTIES.forEach(property -> resource.block((String)property).attribute("encrypted").reportIfAbsent(OMITTING_MESSAGE, new SecondaryLocation[0]).reportIf(ExpressionPredicate.isFalse(), MESSAGE, new SecondaryLocation[0])));
    }
}

