/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.plugin;

import java.util.Arrays;
import java.util.List;
import org.sonar.api.PropertyType;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.iac.terraform.plugin.TerraformProviders;

public class TerraformSettings {
    private static final String TERRAFORM_CATEGORY = "Terraform";
    private static final String GENERAL_SUBCATEGORY = "General";
    private static final String VERSION_SUBCATEGORY = "Provider Versions";
    static final String ACTIVATION_KEY = "sonar.terraform.activate";
    static final String ACTIVATION_DEFAULT_VALUE = "true";
    static final String FILE_SUFFIXES_KEY = "sonar.terraform.file.suffixes";
    static final String FILE_SUFFIXES_DEFAULT_VALUE = ".tf";

    private TerraformSettings() {
    }

    public static List<PropertyDefinition> getProperties() {
        return Arrays.asList(PropertyDefinition.builder((String)ACTIVATION_KEY).index(1).defaultValue(ACTIVATION_DEFAULT_VALUE).name("Activate Terraform Analysis").description("Disabling Terraform analysis ensures that no Terraform files are parsed, highlighted and analyzed, and no IaC analysis results are included in the quality gate.").type(PropertyType.BOOLEAN).onQualifiers("TRK", new String[0]).category(TERRAFORM_CATEGORY).subCategory(GENERAL_SUBCATEGORY).build(), PropertyDefinition.builder((String)FILE_SUFFIXES_KEY).index(2).defaultValue(FILE_SUFFIXES_DEFAULT_VALUE).name("File Suffixes").description("List of suffixes of Terraform files to analyze.").onQualifiers("TRK", new String[0]).category(TERRAFORM_CATEGORY).multiValues(true).subCategory(GENERAL_SUBCATEGORY).build(), PropertyDefinition.builder((String)TerraformProviders.Provider.Identifier.AWS.key).index(100).name("AWS Provider Version").description("Version of the AWS provider of lifecycle management of AWS resources. Use semantic versioning format like `3.4`, `4.17.1` or `4`").type(PropertyType.STRING).onQualifiers("TRK", new String[0]).category(TERRAFORM_CATEGORY).subCategory(VERSION_SUBCATEGORY).build(), PropertyDefinition.builder((String)TerraformProviders.Provider.Identifier.AZURE.key).index(101).name("Azure Provider Version").description("Version of the Azure Resource Manager provider of lifecycle management of Microsoft Azure resources. Use semantic versioning format like `3.4`, `4.17.1` or `4`").type(PropertyType.STRING).onQualifiers("TRK", new String[0]).category(TERRAFORM_CATEGORY).subCategory(VERSION_SUBCATEGORY).build());
    }
}

