/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Predicate;
import javaslang.Tuple;
import javaslang.Tuple2;
import javaslang.collection.LinearSeq;
import javaslang.collection.List;

public class Queue<T>
implements Serializable,
LinearSeq<T> {
    private static final long serialVersionUID = 1L;
    private static final Queue<?> EMPTY = new Queue(List.empty(), List.empty());
    private final List<T> front;
    private final List<T> rear;

    private Queue(List<T> front, List<T> rear) {
        boolean frontIsEmpty = front.isEmpty();
        this.front = frontIsEmpty ? rear.reverse() : front;
        this.rear = frontIsEmpty ? front : rear;
    }

    public static <T> Queue<T> empty() {
        return EMPTY;
    }

    public static <T> Queue<T> of(T element) {
        return Queue.ofAll(List.of(element));
    }

    public static <T> Queue<T> ofAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (elements instanceof Queue) {
            return (Queue)elements;
        }
        if (!elements.iterator().hasNext()) {
            return Queue.empty();
        }
        if (elements instanceof List) {
            return new Queue((List)elements, List.empty());
        }
        return new Queue<T>(List.ofAll(elements), List.empty());
    }

    public Tuple2<T, Queue<T>> dequeue() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("dequeue of empty Queue");
        }
        return Tuple.of(this.head(), this.tail());
    }

    public Queue<T> enqueue(T element) {
        return new Queue<T>(this.front, this.rear.prepend(element));
    }

    public Queue<T> enqueueAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        List<T> temp = this.rear;
        for (T element : elements) {
            temp = temp.prepend(element);
        }
        return new Queue<T>(this.front, temp);
    }

    public Queue<T> append(T element) {
        return this.enqueue(element);
    }

    public Queue<T> appendAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        return this.enqueueAll(elements);
    }

    public Queue<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        List<T> filtered = this.toList().filter(predicate);
        return filtered.length() == this.length() ? this : filtered.toQueue();
    }

    @Override
    public T get(int index2) {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("get(" + index2 + ") on empty Queue");
        }
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("get(" + index2 + ")");
        }
        int length = this.front.length();
        if (index2 < length) {
            return this.front.get(index2);
        }
        int rearIndex = index2 - length;
        int rearLength = this.rear.length();
        if (rearIndex < rearLength) {
            int reverseRearIndex = rearLength - rearIndex - 1;
            return this.rear.get(reverseRearIndex);
        }
        throw new IndexOutOfBoundsException(String.format("get(%s) on Queue of length %s", index2, this.length()));
    }

    @Override
    public T head() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("head of empty queue");
        }
        return this.front.head();
    }

    public Queue<T> init() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("init of empty Queue");
        }
        if (this.rear.isEmpty()) {
            return new Queue<T>(this.front.init(), this.rear);
        }
        return new Queue<T>(this.front, this.rear.tail());
    }

    @Override
    public boolean isEmpty() {
        return this.front.isEmpty();
    }

    @Override
    public boolean isTraversableAgain() {
        return true;
    }

    @Override
    public int length() {
        return this.front.length() + this.rear.length();
    }

    @Override
    public <U> Queue<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return new Queue<T>(this.front.map(mapper), this.rear.map(mapper));
    }

    public Queue<T> remove(T element) {
        List removed = this.toList().remove(element);
        return removed.length() == this.length() ? this : removed.toQueue();
    }

    public Queue<T> removeFirst(Predicate<T> predicate) {
        List removed = this.toList().removeFirst(predicate);
        return removed.length() == this.length() ? this : removed.toQueue();
    }

    public Queue<T> replace(T currentElement, T newElement) {
        List<T> newFront = this.front.replace(currentElement, newElement);
        List<T> newRear = this.rear.replace(currentElement, newElement);
        return newFront.size() + newRear.size() == 0 ? Queue.empty() : (newFront == this.front && newRear == this.rear ? this : new Queue<T>(newFront, newRear));
    }

    @Override
    public Spliterator<T> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.length(), 1040);
    }

    @Override
    public Queue<T> tail() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("tail of empty Queue");
        }
        return new Queue<T>(this.front.tail(), this.rear);
    }

    private Object readResolve() {
        return this.isEmpty() ? EMPTY : this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Queue) {
            Queue that = (Queue)o;
            return this.toList().equals(that.toList());
        }
        return false;
    }

    public int hashCode() {
        return this.toList().hashCode();
    }

    @Override
    public String stringPrefix() {
        return "Queue";
    }

    @Override
    public String toString() {
        return this.mkString(this.stringPrefix() + "(", ", ", ")");
    }
}

