/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.ir.IrUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.Closure;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitor;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\tH\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u000bJ\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u000eJ\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\tH\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\u00020\t*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0018\u0010\n\u001a\u00020\t*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000fR\u001a\u0010\u0010\u001a\u0004\u0018\u00010\t*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u0004\u0018\u00010\t*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator;", "", "irElement", "Lorg/jetbrains/kotlin/ir/IrElement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "(Lorg/jetbrains/kotlin/ir/IrElement;Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)V", "closureBuilders", "", "Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "closureBuilder", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getClosureBuilder", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "closureBuilderOrNull", "getClosureBuilderOrNull", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "parentClosureBuilder", "getParentClosureBuilder", "collectPotentiallyCapturedTypeParameters", "", "getClassClosure", "Lorg/jetbrains/kotlin/backend/common/lower/Closure;", "getClosure", "getFunctionClosure", "includeInParent", "builder", "ClosureBuilder", "ClosureCollectorVisitor", "ir.backend.common"})
public final class ClosureAnnotator {
    @NotNull
    private final Map<IrDeclaration, ClosureBuilder> closureBuilders;

    public ClosureAnnotator(@NotNull IrElement irElement, @NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter(irElement, "irElement");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        this.closureBuilders = new LinkedHashMap();
        IrElementVisitor irElementVisitor = new ClosureCollectorVisitor();
        ClosureBuilder closureBuilder = this.getClosureBuilderOrNull(declaration);
        if (closureBuilder == null) {
            closureBuilder = this.getParentClosureBuilder(declaration);
        }
        irElement.accept(irElementVisitor, closureBuilder);
    }

    @NotNull
    public final Closure getFunctionClosure(@NotNull IrFunction declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        return this.getClosure(declaration);
    }

    @NotNull
    public final Closure getClassClosure(@NotNull IrClass declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        return this.getClosure(declaration);
    }

    private final Closure getClosure(IrDeclaration declaration) {
        ClosureBuilder closureBuilder = this.closureBuilders.get(declaration);
        if (closureBuilder == null) {
            boolean bl = false;
            throw new AssertionError((Object)("No closure builder for passed declaration " + IrUtilsKt.ir2string(declaration) + '.'));
        }
        return closureBuilder.buildClosure();
    }

    private final void includeInParent(ClosureBuilder builder) {
        ClosureBuilder parentBuilder = this.getParentClosureBuilder(builder.getOwner());
        if (parentBuilder != null && !(parentBuilder.getOwner() instanceof IrFunction)) {
            parentBuilder.include(builder);
        }
    }

    private final ClosureBuilder getClosureBuilder(IrClass $this$closureBuilder) {
        ClosureBuilder closureBuilder;
        Map<IrDeclaration, ClosureBuilder> $this$getOrPut$iv = this.closureBuilders;
        boolean $i$f$getOrPut = false;
        ClosureBuilder value$iv = $this$getOrPut$iv.get($this$closureBuilder);
        if (value$iv == null) {
            Object v1;
            ClosureBuilder closureBuilder2;
            block10: {
                boolean bl = false;
                closureBuilder2 = new ClosureBuilder($this$closureBuilder);
                this.collectPotentiallyCapturedTypeParameters(closureBuilder2);
                closureBuilder2.declareVariable($this$closureBuilder.getThisReceiver());
                if ($this$closureBuilder.isInner()) {
                    IrValueParameter irValueParameter;
                    IrDeclarationParent parent2 = $this$closureBuilder.getParent();
                    if (parent2 instanceof IrClass) {
                        irValueParameter = ((IrClass)parent2).getThisReceiver();
                    } else if (parent2 instanceof IrScript) {
                        irValueParameter = ((IrScript)parent2).getThisReceiver();
                    } else {
                        throw new IllegalStateException(("unexpected parent " + parent2).toString());
                    }
                    IrValueParameter receiver = irValueParameter;
                    closureBuilder2.declareVariable(receiver);
                    this.includeInParent(closureBuilder2);
                }
                Iterable $this$firstOrNull$iv = $this$closureBuilder.getDeclarations();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    IrDeclaration it = (IrDeclaration)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof IrConstructor && ((IrConstructor)it).isPrimary())) continue;
                    v1 = element$iv;
                    break block10;
                }
                v1 = null;
            }
            IrDeclaration irDeclaration2 = v1;
            if (irDeclaration2 != null) {
                IrDeclaration it = irDeclaration2;
                boolean bl = false;
                Intrinsics.checkNotNull(it, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrConstructor");
                IrConstructor constructor = (IrConstructor)it;
                Iterable $this$forEach$iv = constructor.getValueParameters();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IrValueParameter v = (IrValueParameter)element$iv;
                    boolean bl3 = false;
                    closureBuilder2.declareVariable(v);
                }
            }
            ClosureBuilder answer$iv = closureBuilder2;
            $this$getOrPut$iv.put($this$closureBuilder, answer$iv);
            closureBuilder = answer$iv;
        } else {
            closureBuilder = value$iv;
        }
        return closureBuilder;
    }

    private final ClosureBuilder getClosureBuilder(IrFunction $this$closureBuilder) {
        ClosureBuilder closureBuilder;
        Map<IrDeclaration, ClosureBuilder> $this$getOrPut$iv = this.closureBuilders;
        boolean $i$f$getOrPut = false;
        ClosureBuilder value$iv = $this$getOrPut$iv.get($this$closureBuilder);
        if (value$iv == null) {
            boolean bl = false;
            ClosureBuilder closureBuilder2 = new ClosureBuilder($this$closureBuilder);
            this.collectPotentiallyCapturedTypeParameters(closureBuilder2);
            Iterable $this$forEach$iv = $this$closureBuilder.getValueParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrValueParameter it = (IrValueParameter)element$iv;
                boolean bl2 = false;
                closureBuilder2.declareVariable(it);
            }
            closureBuilder2.declareVariable($this$closureBuilder.getDispatchReceiverParameter());
            closureBuilder2.declareVariable($this$closureBuilder.getExtensionReceiverParameter());
            closureBuilder2.seeType($this$closureBuilder.getReturnType());
            if ($this$closureBuilder instanceof IrConstructor) {
                IrDeclarationParent irDeclarationParent = $this$closureBuilder.getParent();
                Intrinsics.checkNotNull(irDeclarationParent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                IrClass constructedClass = (IrClass)irDeclarationParent;
                closureBuilder2.declareVariable(constructedClass.getThisReceiver());
                ClosureBuilder classBuilder2 = this.getClosureBuilder(constructedClass);
                closureBuilder2.include(classBuilder2);
            }
            ClosureBuilder answer$iv = closureBuilder2;
            $this$getOrPut$iv.put($this$closureBuilder, answer$iv);
            closureBuilder = answer$iv;
        } else {
            closureBuilder = value$iv;
        }
        return closureBuilder;
    }

    private final void collectPotentiallyCapturedTypeParameters(ClosureBuilder closureBuilder) {
        ClosureBuilder current = this.getParentClosureBuilder(closureBuilder.getOwner());
        while (current != null) {
            IrDeclaration container = current.getOwner();
            if (container instanceof IrTypeParametersContainer) {
                for (IrTypeParameter typeParameter : ((IrTypeParametersContainer)container).getTypeParameters()) {
                    closureBuilder.addPotentiallyCapturedTypeParameter(typeParameter);
                }
            }
            current = this.getParentClosureBuilder(container);
        }
    }

    private final ClosureBuilder getParentClosureBuilder(IrDeclaration $this$parentClosureBuilder) {
        IrDeclarationParent p = $this$parentClosureBuilder.getParent();
        return p instanceof IrClass ? this.getClosureBuilder((IrClass)p) : (p instanceof IrFunction ? this.getClosureBuilder((IrFunction)p) : (p instanceof IrDeclaration ? this.getParentClosureBuilder((IrDeclaration)((Object)p)) : null));
    }

    private final ClosureBuilder getClosureBuilderOrNull(IrDeclaration $this$closureBuilderOrNull) {
        IrDeclaration irDeclaration2 = $this$closureBuilderOrNull;
        return irDeclaration2 instanceof IrClass ? this.getClosureBuilder((IrClass)$this$closureBuilderOrNull) : (irDeclaration2 instanceof IrFunction ? this.getClosureBuilder((IrFunction)$this$closureBuilderOrNull) : null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007J\u0006\u0010\u0015\u001a\u00020\u000bJ\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00000\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0000J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0007J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\rJ\u000e\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\tJ\b\u0010$\u001a\u00020\u001dH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "", "owner", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)V", "capturedTypeParameters", "", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "capturedValues", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "closure", "Lorg/jetbrains/kotlin/backend/common/lower/Closure;", "declaredValues", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "includes", "getOwner", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "potentiallyCapturedTypeParameters", "addPotentiallyCapturedTypeParameter", "", "param", "buildClosure", "collectConnectedClosures", "", "declareVariable", "valueDeclaration", "include", "includingBuilder", "isExternal", "", "typeParameter", "seeType", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "seeVariable", "value", "updateFromIncluded", "ir.backend.common"})
    private static final class ClosureBuilder {
        @NotNull
        private final IrDeclaration owner;
        @NotNull
        private final Set<IrValueSymbol> capturedValues;
        @NotNull
        private final Set<IrValueDeclaration> declaredValues;
        @NotNull
        private final Set<ClosureBuilder> includes;
        @NotNull
        private final Set<IrTypeParameter> potentiallyCapturedTypeParameters;
        @NotNull
        private final Set<IrTypeParameter> capturedTypeParameters;
        @Nullable
        private Closure closure;

        public ClosureBuilder(@NotNull IrDeclaration owner) {
            Intrinsics.checkNotNullParameter(owner, "owner");
            this.owner = owner;
            this.capturedValues = new LinkedHashSet();
            this.declaredValues = new LinkedHashSet();
            this.includes = new LinkedHashSet();
            this.potentiallyCapturedTypeParameters = new LinkedHashSet();
            this.capturedTypeParameters = new LinkedHashSet();
        }

        @NotNull
        public final IrDeclaration getOwner() {
            return this.owner;
        }

        @NotNull
        public final Closure buildClosure() {
            boolean changes;
            Closure closure = this.closure;
            if (closure != null) {
                Closure it = closure;
                boolean bl = false;
                return it;
            }
            List<ClosureBuilder> work = this.collectConnectedClosures();
            do {
                changes = false;
                for (ClosureBuilder c : work) {
                    if (!c.updateFromIncluded()) continue;
                    changes = true;
                }
            } while (changes);
            for (ClosureBuilder c : work) {
                c.closure = new Closure(CollectionsKt.toList((Iterable)c.capturedValues), CollectionsKt.toList((Iterable)c.capturedTypeParameters));
            }
            Closure closure2 = this.closure;
            if (closure2 == null) {
                throw new AssertionError((Object)("Closure should have been built for " + RenderIrElementKt.render(this.owner)));
            }
            return closure2;
        }

        private final List<ClosureBuilder> collectConnectedClosures() {
            LinkedHashSet<ClosureBuilder> connected = new LinkedHashSet<ClosureBuilder>();
            connected.add(this);
            ClosureBuilder.collectConnectedClosures$collectRec(connected, this);
            return CollectionsKt.asReversed(CollectionsKt.toList((Iterable)connected));
        }

        private final boolean updateFromIncluded() {
            if (this.closure != null) {
                throw new AssertionError((Object)("Closure has already been built for " + RenderIrElementKt.render(this.owner)));
            }
            int capturedValuesBefore = this.capturedValues.size();
            int capturedTypeParametersBefore = this.capturedTypeParameters.size();
            for (ClosureBuilder subClosure : this.includes) {
                Object it;
                Iterable $this$filterTo$iv;
                Iterable iterable = subClosure.capturedValues;
                Collection destination$iv = this.capturedValues;
                boolean $i$f$filterTo = false;
                for (Object element$iv : $this$filterTo$iv) {
                    it = (IrValueSymbol)element$iv;
                    boolean bl = false;
                    if (!this.isExternal(it.getOwner())) continue;
                    destination$iv.add(element$iv);
                }
                $this$filterTo$iv = subClosure.capturedTypeParameters;
                destination$iv = this.capturedTypeParameters;
                $i$f$filterTo = false;
                for (Object element$iv : $this$filterTo$iv) {
                    it = (IrTypeParameter)element$iv;
                    boolean bl = false;
                    if (!this.isExternal((IrTypeParameter)it)) continue;
                    destination$iv.add(element$iv);
                }
            }
            return this.capturedValues.size() != capturedValuesBefore || this.capturedTypeParameters.size() != capturedTypeParametersBefore;
        }

        public final void include(@NotNull ClosureBuilder includingBuilder) {
            Intrinsics.checkNotNullParameter(includingBuilder, "includingBuilder");
            this.includes.add(includingBuilder);
        }

        public final void declareVariable(@Nullable IrValueDeclaration valueDeclaration) {
            if (valueDeclaration != null) {
                this.declaredValues.add(valueDeclaration);
                this.seeType(valueDeclaration.getType());
            }
        }

        public final void seeVariable(@NotNull IrValueSymbol value2) {
            Intrinsics.checkNotNullParameter(value2, "value");
            if (this.isExternal(value2.getOwner())) {
                this.capturedValues.add(value2);
            }
        }

        public final boolean isExternal(@NotNull IrValueDeclaration valueDeclaration) {
            Intrinsics.checkNotNullParameter(valueDeclaration, "valueDeclaration");
            return !this.declaredValues.contains(valueDeclaration);
        }

        public final boolean isExternal(@NotNull IrTypeParameter typeParameter) {
            Intrinsics.checkNotNullParameter(typeParameter, "typeParameter");
            return this.potentiallyCapturedTypeParameters.contains(typeParameter);
        }

        public final void addPotentiallyCapturedTypeParameter(@NotNull IrTypeParameter param) {
            Intrinsics.checkNotNullParameter(param, "param");
            this.potentiallyCapturedTypeParameters.add(param);
        }

        public final void seeType(@NotNull IrType type2) {
            block5: {
                boolean $i$f$forEach;
                Iterable $this$forEach$iv;
                Intrinsics.checkNotNullParameter(type2, "type");
                if (!(type2 instanceof IrSimpleType)) {
                    return;
                }
                IrClassifierSymbol classifier2 = ((IrSimpleType)type2).getClassifier();
                if (classifier2 instanceof IrTypeParameterSymbol && this.isExternal((IrTypeParameter)((IrTypeParameterSymbol)classifier2).getOwner()) && this.capturedTypeParameters.add((IrTypeParameter)((IrTypeParameterSymbol)classifier2).getOwner())) {
                    $this$forEach$iv = ((IrTypeParameter)((IrTypeParameterSymbol)classifier2).getOwner()).getSuperTypes();
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        IrType p0 = (IrType)element$iv;
                        boolean bl = false;
                        this.seeType(p0);
                    }
                }
                $this$forEach$iv = ((IrSimpleType)type2).getArguments();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IrTypeArgument it = (IrTypeArgument)element$iv;
                    boolean bl = false;
                    Object object = it instanceof IrTypeProjection ? (IrTypeProjection)it : null;
                    if (object == null || (object = object.getType()) == null) continue;
                    Object p0 = object;
                    boolean bl2 = false;
                    this.seeType((IrType)p0);
                }
                Object object = ((IrSimpleType)type2).getAbbreviation();
                if (object == null || (object = object.getArguments()) == null) break block5;
                Iterable $this$forEach$iv2 = (Iterable)object;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    IrTypeArgument it = (IrTypeArgument)element$iv;
                    boolean bl = false;
                    Object object2 = it instanceof IrTypeProjection ? (IrTypeProjection)it : null;
                    if (object2 == null || (object2 = object2.getType()) == null) continue;
                    Object p0 = object2;
                    boolean bl3 = false;
                    this.seeType((IrType)p0);
                }
            }
        }

        private static final void collectConnectedClosures$collectRec(LinkedHashSet<ClosureBuilder> connected, ClosureBuilder current) {
            for (ClosureBuilder included : current.includes) {
                if (included.closure != null || !connected.add(included)) continue;
                ClosureBuilder.collectConnectedClosures$collectRec(connected, included);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0002J\u001a\u0010\t\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00132\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00152\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00172\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00192\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u001b2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u001d2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u001f2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010 \u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020!2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureCollectorVisitor;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitor;", "", "Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "(Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator;)V", "processMemberAccess", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "parentClosure", "visitClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "data", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitExpression", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "visitFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitFunctionAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "visitFunctionExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionExpression;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "visitTypeParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "visitValueAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrValueAccessExpression;", "visitVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "ir.backend.common"})
    private final class ClosureCollectorVisitor
    implements IrElementVisitor<Unit, ClosureBuilder> {
        @Override
        public void visitElement(@NotNull IrElement element, @Nullable ClosureBuilder data2) {
            Intrinsics.checkNotNullParameter(element, "element");
            element.acceptChildren(this, data2);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration, @Nullable ClosureBuilder data2) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            declaration.acceptChildren(this, ClosureAnnotator.this.getClosureBuilder(declaration));
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration, @Nullable ClosureBuilder data2) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            ClosureBuilder closureBuilder = ClosureAnnotator.this.getClosureBuilder(declaration);
            declaration.acceptChildren(this, closureBuilder);
            ClosureAnnotator.this.includeInParent(closureBuilder);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable ClosureBuilder data2) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            for (IrType superType2 : declaration.getSuperTypes()) {
                ClosureBuilder closureBuilder = data2;
                if (closureBuilder == null) continue;
                closureBuilder.seeType(superType2);
            }
        }

        @Override
        public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable ClosureBuilder data2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            ClosureBuilder closureBuilder = data2;
            if (closureBuilder != null) {
                closureBuilder.seeVariable(expression2.getSymbol());
            }
            IrElementVisitor.DefaultImpls.visitValueAccess(this, expression2, data2);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration, @Nullable ClosureBuilder data2) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            ClosureBuilder closureBuilder = data2;
            if (closureBuilder != null) {
                closureBuilder.declareVariable(declaration);
            }
            IrElementVisitor.DefaultImpls.visitVariable(this, declaration, data2);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable ClosureBuilder data2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitor.DefaultImpls.visitFunctionAccess(this, expression2, data2);
            this.processMemberAccess(((IrFunctionSymbol)expression2.getSymbol()).getOwner(), data2);
        }

        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable ClosureBuilder data2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitor.DefaultImpls.visitFunctionReference(this, expression2, data2);
            this.processMemberAccess(((IrFunctionSymbol)expression2.getSymbol()).getOwner(), data2);
        }

        @Override
        public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable ClosureBuilder data2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitor.DefaultImpls.visitFunctionExpression(this, expression2, data2);
            this.processMemberAccess(expression2.getFunction(), data2);
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable ClosureBuilder data2) {
            block1: {
                IrSimpleFunctionSymbol it;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrElementVisitor.DefaultImpls.visitPropertyReference(this, expression2, data2);
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = expression2.getGetter();
                if (irSimpleFunctionSymbol != null) {
                    it = irSimpleFunctionSymbol;
                    boolean bl = false;
                    this.processMemberAccess((IrDeclaration)it.getOwner(), data2);
                }
                IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = expression2.getSetter();
                if (irSimpleFunctionSymbol2 == null) break block1;
                it = irSimpleFunctionSymbol2;
                boolean bl = false;
                this.processMemberAccess((IrDeclaration)it.getOwner(), data2);
            }
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression2, @Nullable ClosureBuilder data2) {
            block3: {
                ClosureBuilder typeParameterContainerScopeBuilder;
                Object object;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrElementVisitor.DefaultImpls.visitExpression(this, expression2, data2);
                ClosureBuilder closureBuilder = data2;
                if (closureBuilder != null) {
                    ClosureBuilder closureBuilder2 = closureBuilder;
                    ClosureAnnotator closureAnnotator = ClosureAnnotator.this;
                    ClosureBuilder it = closureBuilder2;
                    boolean bl = false;
                    IrDeclaration irDeclaration2 = it.getOwner();
                    object = irDeclaration2 instanceof IrConstructor ? (IrConstructor)irDeclaration2 : null;
                    if (object == null || (object = closureAnnotator.getClosureBuilder((IrFunction)object)) == null) {
                        object = it;
                    }
                } else {
                    object = null;
                }
                ClosureBuilder closureBuilder3 = typeParameterContainerScopeBuilder = object;
                if (closureBuilder3 == null) break block3;
                closureBuilder3.seeType(expression2.getType());
            }
        }

        private final void processMemberAccess(IrDeclaration declaration, ClosureBuilder parentClosure) {
            block3: {
                ClosureBuilder builder;
                if (!AdditionalIrUtilsKt.isLocal(declaration)) break block3;
                if (declaration instanceof IrSimpleFunction && !Intrinsics.areEqual(((IrSimpleFunction)declaration).getVisibility(), DescriptorVisibilities.LOCAL)) {
                    return;
                }
                ClosureBuilder closureBuilder = builder = ClosureAnnotator.this.getClosureBuilderOrNull(declaration);
                if (closureBuilder != null) {
                    ClosureBuilder it = closureBuilder;
                    boolean bl = false;
                    ClosureBuilder closureBuilder2 = parentClosure;
                    if (closureBuilder2 != null) {
                        closureBuilder2.include(builder);
                    }
                }
            }
        }

        @Override
        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitAnonymousInitializer(this, declaration, data2);
        }

        @Override
        public void visitBlock(@NotNull IrBlock expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitBlock(this, expression2, data2);
        }

        @Override
        public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitBlockBody(this, body2, data2);
        }

        @Override
        public void visitBody(@NotNull IrBody body2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitBody(this, body2, data2);
        }

        @Override
        public void visitBranch(@NotNull IrBranch branch, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitBranch(this, branch, data2);
        }

        @Override
        public void visitBreak(@NotNull IrBreak jump, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitBreak(this, jump, data2);
        }

        @Override
        public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitBreakContinue(this, jump, data2);
        }

        @Override
        public void visitCall(@NotNull IrCall expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitCall(this, expression2, data2);
        }

        @Override
        public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitCallableReference(this, expression2, data2);
        }

        @Override
        public void visitCatch(@NotNull IrCatch aCatch, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitCatch(this, aCatch, data2);
        }

        @Override
        public void visitClassReference(@NotNull IrClassReference expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitClassReference(this, expression2, data2);
        }

        @Override
        public void visitComposite(@NotNull IrComposite expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitComposite(this, expression2, data2);
        }

        @Override
        public void visitConst(@NotNull IrConst<?> expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitConst(this, expression2, data2);
        }

        @Override
        public void visitConstantArray(@NotNull IrConstantArray expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitConstantArray(this, expression2, data2);
        }

        @Override
        public void visitConstantObject(@NotNull IrConstantObject expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitConstantObject(this, expression2, data2);
        }

        @Override
        public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitConstantPrimitive(this, expression2, data2);
        }

        @Override
        public void visitConstantValue(@NotNull IrConstantValue expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitConstantValue(this, expression2, data2);
        }

        @Override
        public void visitConstructor(@NotNull IrConstructor declaration, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitConstructor(this, declaration, data2);
        }

        @Override
        public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitConstructorCall(this, expression2, data2);
        }

        @Override
        public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitContainerExpression(this, expression2, data2);
        }

        @Override
        public void visitContinue(@NotNull IrContinue jump, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitContinue(this, jump, data2);
        }

        @Override
        public void visitDeclaration(@NotNull IrDeclarationBase declaration, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitDeclaration(this, declaration, data2);
        }

        @Override
        public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitDeclarationReference(this, expression2, data2);
        }

        @Override
        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
        }

        @Override
        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitDoWhileLoop(this, loop, data2);
        }

        @Override
        public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitDynamicExpression(this, expression2, data2);
        }

        @Override
        public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
        }

        @Override
        public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
        }

        @Override
        public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitElseBranch(this, branch, data2);
        }

        @Override
        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
        }

        @Override
        public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitEnumEntry(this, declaration, data2);
        }

        @Override
        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
        }

        @Override
        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitErrorDeclaration(this, declaration, data2);
        }

        @Override
        public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitErrorExpression(this, expression2, data2);
        }

        @Override
        public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitExpressionBody(this, body2, data2);
        }

        @Override
        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitExternalPackageFragment(this, declaration, data2);
        }

        @Override
        public void visitField(@NotNull IrField declaration, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitField(this, declaration, data2);
        }

        @Override
        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitFieldAccess(this, expression2, data2);
        }

        @Override
        public void visitFile(@NotNull IrFile declaration, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitFile(this, declaration, data2);
        }

        @Override
        public void visitGetClass(@NotNull IrGetClass expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitGetClass(this, expression2, data2);
        }

        @Override
        public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitGetEnumValue(this, expression2, data2);
        }

        @Override
        public void visitGetField(@NotNull IrGetField expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitGetField(this, expression2, data2);
        }

        @Override
        public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitGetObjectValue(this, expression2, data2);
        }

        @Override
        public void visitGetValue(@NotNull IrGetValue expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitGetValue(this, expression2, data2);
        }

        @Override
        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
        }

        @Override
        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data2);
        }

        @Override
        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
        }

        @Override
        public void visitLoop(@NotNull IrLoop loop, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitLoop(this, loop, data2);
        }

        @Override
        public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitMemberAccess(this, expression2, data2);
        }

        @Override
        public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitModuleFragment(this, declaration, data2);
        }

        @Override
        public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitPackageFragment(this, declaration, data2);
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitProperty(this, declaration, data2);
        }

        @Override
        public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
        }

        @Override
        public void visitReturn(@NotNull IrReturn expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitReturn(this, expression2, data2);
        }

        @Override
        public void visitScript(@NotNull IrScript declaration, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitScript(this, declaration, data2);
        }

        @Override
        public void visitSetField(@NotNull IrSetField expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitSetField(this, expression2, data2);
        }

        @Override
        public void visitSetValue(@NotNull IrSetValue expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitSetValue(this, expression2, data2);
        }

        @Override
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitSimpleFunction(this, declaration, data2);
        }

        @Override
        public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitSingletonReference(this, expression2, data2);
        }

        @Override
        public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitSpreadElement(this, spread, data2);
        }

        @Override
        public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitStringConcatenation(this, expression2, data2);
        }

        @Override
        public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
        }

        @Override
        public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
        }

        @Override
        public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitSyntheticBody(this, body2, data2);
        }

        @Override
        public void visitThrow(@NotNull IrThrow expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitThrow(this, expression2, data2);
        }

        @Override
        public void visitTry(@NotNull IrTry aTry, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitTry(this, aTry, data2);
        }

        @Override
        public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitTypeAlias(this, declaration, data2);
        }

        @Override
        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitTypeOperator(this, expression2, data2);
        }

        @Override
        public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitValueParameter(this, declaration, data2);
        }

        @Override
        public void visitVararg(@NotNull IrVararg expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitVararg(this, expression2, data2);
        }

        @Override
        public void visitWhen(@NotNull IrWhen expression2, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitWhen(this, expression2, data2);
        }

        @Override
        public void visitWhileLoop(@NotNull IrWhileLoop loop, @Nullable ClosureBuilder data2) {
            IrElementVisitor.DefaultImpls.visitWhileLoop(this, loop, data2);
        }
    }
}

