/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.editor.impl;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.editor.event.DocumentEvent;
import org.jetbrains.kotlin.com.intellij.openapi.editor.ex.DocumentEx;
import org.jetbrains.kotlin.com.intellij.openapi.editor.ex.RangeMarkerEx;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.IntervalTreeImpl;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.RangeMarkerTree;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.StripedIDGenerator;
import org.jetbrains.kotlin.com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.util.ProperTextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.UnfairTextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtilRt;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;

public class RangeMarkerImpl
extends UserDataHolderBase
implements RangeMarkerEx {
    private static final Logger LOG = Logger.getInstance(RangeMarkerImpl.class);
    @NotNull
    private final Object myDocumentOrFile;
    RangeMarkerTree.RMNode<RangeMarkerEx> myNode;
    private final long myId;
    private static final StripedIDGenerator counter = new StripedIDGenerator();

    protected void unregisterInTree() {
        if (!this.isValid()) {
            return;
        }
        IntervalTreeImpl tree = this.myNode.getTree();
        tree.checkMax(true);
        DocumentEx document = this.getCachedDocument();
        if (document == null) {
            this.myNode = null;
        } else {
            document.removeRangeMarker(this);
        }
        tree.checkMax(true);
    }

    public long getId() {
        return this.myId;
    }

    @Override
    public void dispose() {
        this.unregisterInTree();
    }

    @Override
    public int getStartOffset() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node == null ? -1 : node.intervalStart() + node.computeDeltaUpToRoot();
    }

    @Override
    public int getEndOffset() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node == null ? -1 : node.intervalEnd() + node.computeDeltaUpToRoot();
    }

    void invalidate(@NotNull Object reason) {
        if (reason == null) {
            RangeMarkerImpl.$$$reportNull$$$0(4);
        }
        this.setValid(false);
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node != null) {
            node.processAliveKeys(markerEx -> {
                this.myNode.getTree().beforeRemove(markerEx, reason);
                return true;
            });
        }
    }

    DocumentEx getCachedDocument() {
        Object file2 = this.myDocumentOrFile;
        return file2 instanceof VirtualFile ? (DocumentEx)FileDocumentManager.getInstance().getCachedDocument((VirtualFile)file2) : (DocumentEx)file2;
    }

    @Override
    public boolean isGreedyToLeft() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node != null && node.isGreedyToLeft();
    }

    @Override
    public boolean isGreedyToRight() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node != null && node.isGreedyToRight();
    }

    public boolean isStickingToRight() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node != null && node.isStickingToRight();
    }

    public final void documentChanged(@NotNull DocumentEvent e) {
        int newEnd;
        int newStart;
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(6);
        }
        int oldStart = this.intervalStart();
        int oldEnd = this.intervalEnd();
        int docLength = e.getDocument().getTextLength();
        if (!this.isValid()) {
            LOG.error("Invalid range marker " + (this.isGreedyToLeft() ? "[" : "(") + oldStart + ", " + oldEnd + (this.isGreedyToRight() ? "]" : ")") + ". Event = " + e + ". Doc length=" + docLength + "; " + this.getClass());
            return;
        }
        if (oldStart > oldEnd || oldStart < 0 || oldEnd > docLength - e.getNewLength() + e.getOldLength()) {
            LOG.error("RangeMarker" + (this.isGreedyToLeft() ? "[" : "(") + oldStart + ", " + oldEnd + (this.isGreedyToRight() ? "]" : ")") + " is invalid before update. Event = " + e + ". Doc length=" + docLength + "; " + this.getClass());
            this.invalidate(e);
            return;
        }
        this.changedUpdateImpl(e);
        if (this.isValid() && ((newStart = this.intervalStart()) > (newEnd = this.intervalEnd()) || newStart < 0 || newEnd > docLength)) {
            LOG.error("Update failed. Event = " + e + ". Doc length=" + docLength + "; " + this.getClass() + ". Before update: " + (this.isGreedyToLeft() ? "[" : "(") + oldStart + ", " + oldEnd + (this.isGreedyToRight() ? "]" : ")") + " After update: '" + this + "'");
            this.invalidate(e);
        }
    }

    protected void changedUpdateImpl(@NotNull DocumentEvent e) {
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(7);
        }
        this.doChangeUpdate(e);
    }

    private void doChangeUpdate(@NotNull DocumentEvent e) {
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(8);
        }
        if (!this.isValid()) {
            return;
        }
        TextRange newRange = RangeMarkerImpl.applyChange(e, this.intervalStart(), this.intervalEnd(), this.isGreedyToLeft(), this.isGreedyToRight(), this.isStickingToRight());
        if (newRange == null) {
            this.invalidate(e);
            return;
        }
        this.setIntervalStart(newRange.getStartOffset());
        this.setIntervalEnd(newRange.getEndOffset());
    }

    protected void onReTarget(@NotNull DocumentEvent e) {
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(11);
        }
    }

    @Nullable
    static TextRange applyChange(@NotNull DocumentEvent e, int intervalStart, int intervalEnd, boolean isGreedyToLeft, boolean isGreedyToRight, boolean isStickingToRight) {
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(12);
        }
        if (intervalStart == intervalEnd) {
            return RangeMarkerImpl.processIfOnePoint(e, intervalStart, isGreedyToRight, isStickingToRight);
        }
        int offset = e.getOffset();
        int oldLength = e.getOldLength();
        int newLength = e.getNewLength();
        if (intervalEnd < offset) {
            return new UnfairTextRange(intervalStart, intervalEnd);
        }
        if (!isGreedyToRight && intervalEnd == offset) {
            if (e instanceof DocumentEventImpl && oldLength == 0 && ((DocumentEventImpl)e).getInitialStartOffset() < offset) {
                return new UnfairTextRange(intervalStart, intervalEnd + newLength);
            }
            return new UnfairTextRange(intervalStart, intervalEnd);
        }
        if (intervalStart > offset + oldLength) {
            return new UnfairTextRange(intervalStart + newLength - oldLength, intervalEnd + newLength - oldLength);
        }
        if (!isGreedyToLeft && intervalStart == offset + oldLength) {
            if (e instanceof DocumentEventImpl && oldLength == 0 && ((DocumentEventImpl)e).getInitialStartOffset() + ((DocumentEventImpl)e).getInitialOldLength() > offset) {
                return new UnfairTextRange(intervalStart, intervalEnd + newLength);
            }
            return new UnfairTextRange(intervalStart + newLength - oldLength, intervalEnd + newLength - oldLength);
        }
        if (intervalStart <= offset && intervalEnd >= offset + oldLength) {
            return new ProperTextRange(intervalStart, intervalEnd + newLength - oldLength);
        }
        if (intervalStart >= offset && intervalStart <= offset + oldLength && intervalEnd > offset + oldLength) {
            return new ProperTextRange(offset + newLength, intervalEnd + newLength - oldLength);
        }
        if (intervalEnd >= offset && intervalEnd <= offset + oldLength && intervalStart < offset) {
            return new UnfairTextRange(intervalStart, offset);
        }
        return null;
    }

    @Nullable
    private static TextRange processIfOnePoint(@NotNull DocumentEvent e, int intervalStart, boolean greedyRight, boolean stickyRight) {
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(13);
        }
        int offset = e.getOffset();
        int oldLength = e.getOldLength();
        int oldEnd = offset + oldLength;
        if (offset < intervalStart && intervalStart < oldEnd) {
            return null;
        }
        if (offset == intervalStart && oldLength == 0) {
            if (greedyRight) {
                return new UnfairTextRange(intervalStart, intervalStart + e.getNewLength());
            }
            if (stickyRight) {
                return new UnfairTextRange(intervalStart + e.getNewLength(), intervalStart + e.getNewLength());
            }
        }
        if (intervalStart > oldEnd || intervalStart == oldEnd && oldLength > 0) {
            return new UnfairTextRange(intervalStart + e.getNewLength() - oldLength, intervalStart + e.getNewLength() - oldLength);
        }
        return new UnfairTextRange(intervalStart, intervalStart);
    }

    @NonNls
    public String toString() {
        return "RangeMarker" + (this.isGreedyToLeft() ? "[" : "(") + (this.isValid() ? "" : "invalid:") + this.getStartOffset() + "," + this.getEndOffset() + (this.isGreedyToRight() ? "]" : ")") + " " + this.getId();
    }

    int setIntervalStart(int start) {
        if (start < 0) {
            LOG.error("Negative start: " + start);
        }
        return this.myNode.setIntervalStart(start);
    }

    int setIntervalEnd(int end) {
        if (end < 0) {
            LOG.error("Negative end: " + end);
        }
        return this.myNode.setIntervalEnd(end);
    }

    @Override
    public boolean isValid() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node == null || !node.isValid()) {
            return false;
        }
        Object file2 = this.myDocumentOrFile;
        return file2 instanceof Document || RangeMarkerImpl.canHaveDocument((VirtualFile)file2);
    }

    private static boolean canHaveDocument(@NotNull VirtualFile file2) {
        Document document;
        if (file2 == null) {
            RangeMarkerImpl.$$$reportNull$$$0(14);
        }
        if ((document = FileDocumentManager.getInstance().getCachedDocument(file2)) != null) {
            return true;
        }
        if (!file2.isValid() || file2.isDirectory() || RangeMarkerImpl.isBinaryWithoutDecompiler(file2)) {
            return false;
        }
        return !file2.getFileType().isBinary() || !FileUtilRt.isTooLarge(file2.getLength());
    }

    private static boolean isBinaryWithoutDecompiler(@NotNull VirtualFile file2) {
        FileType fileType;
        if (file2 == null) {
            RangeMarkerImpl.$$$reportNull$$$0(15);
        }
        return (fileType = file2.getFileType()).isBinary() && BinaryFileTypeDecompilers.getInstance().forFileType(fileType) == null;
    }

    public boolean setValid(boolean value2) {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node == null || node.setValid(value2);
    }

    public int intervalStart() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node == null) {
            return -1;
        }
        return node.intervalStart();
    }

    public int intervalEnd() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node == null) {
            return -1;
        }
        return node.intervalEnd();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentOrFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/RangeMarkerImpl";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/editor/impl/RangeMarkerImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "estimateDocumentLength";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invalidate";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "changedUpdateImpl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doChangeUpdate";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "persistentHighlighterUpdate";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "translatedViaDiff";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onReTarget";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "applyChange";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processIfOnePoint";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "canHaveDocument";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryWithoutDecompiler";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

