/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.lang;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtilRt;
import org.jetbrains.kotlin.com.intellij.util.lang.JarLoader;
import org.jetbrains.kotlin.com.intellij.util.lang.MemoryResource;
import org.jetbrains.kotlin.com.intellij.util.lang.Resource;

public final class JarMemoryLoader {
    private final Map<String, Resource> myResources = Collections.synchronizedMap(new HashMap());

    private JarMemoryLoader() {
    }

    public Resource getResource(@NotNull String entryName) {
        if (entryName == null) {
            JarMemoryLoader.$$$reportNull$$$0(0);
        }
        return this.myResources.remove(entryName);
    }

    @Nullable
    static JarMemoryLoader load(@NotNull ZipFile zipFile, @NotNull URL baseUrl, @Nullable JarLoader attributesProvider) throws IOException {
        Enumeration<? extends ZipEntry> entries;
        if (zipFile == null) {
            JarMemoryLoader.$$$reportNull$$$0(1);
        }
        if (baseUrl == null) {
            JarMemoryLoader.$$$reportNull$$$0(2);
        }
        if (!(entries = zipFile.entries()).hasMoreElements()) {
            return null;
        }
        ZipEntry sizeEntry = entries.nextElement();
        if (sizeEntry == null || !sizeEntry.getName().equals("META-INF/jb/$$size$$")) {
            return null;
        }
        byte[] bytes = FileUtilRt.loadBytes(zipFile.getInputStream(sizeEntry), 2);
        int size = ((bytes[1] & 0xFF) << 8) + (bytes[0] & 0xFF);
        JarMemoryLoader loader = new JarMemoryLoader();
        for (int i = 0; i < size && entries.hasMoreElements(); ++i) {
            ZipEntry entry = entries.nextElement();
            MemoryResource resource = MemoryResource.load(baseUrl, zipFile, entry, attributesProvider != null ? attributesProvider.getAttributes() : null);
            loader.myResources.put(entry.getName(), resource);
        }
        return loader;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseUrl";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/lang/JarMemoryLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getResource";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "load";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

