/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.ref;

import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolderEx;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.PairProcessor;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import org.jetbrains.kotlin.com.intellij.util.concurrency.AtomicFieldUpdater;
import org.jetbrains.kotlin.com.intellij.util.containers.FList;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Hash;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;

public final class DebugReflectionUtil {
    private static final Map<Class<?>, Field[]> allFields;
    private static final Field[] EMPTY_FIELD_ARRAY;
    private static final Method Unsafe_shouldBeInitialized;
    private static final Key<Boolean> REPORTED_LEAKED;

    private static Field @NotNull [] getAllFields(@NotNull Class<?> aClass) {
        Field[] cached2;
        if (aClass == null) {
            DebugReflectionUtil.$$$reportNull$$$0(0);
        }
        if ((cached2 = allFields.get(aClass)) == null) {
            try {
                Field[] declaredFields = aClass.getDeclaredFields();
                ArrayList<Field> fields2 = new ArrayList<Field>(declaredFields.length + 5);
                for (Field declaredField2 : declaredFields) {
                    declaredField2.setAccessible(true);
                    Class<?> type2 = declaredField2.getType();
                    if (DebugReflectionUtil.isTrivial(type2)) continue;
                    fields2.add(declaredField2);
                }
                Class<?> superclass = aClass.getSuperclass();
                if (superclass != null) {
                    for (Field sup : DebugReflectionUtil.getAllFields(superclass)) {
                        if (fields2.contains(sup)) continue;
                        fields2.add(sup);
                    }
                }
                cached2 = fields2.isEmpty() ? EMPTY_FIELD_ARRAY : fields2.toArray(new Field[0]);
            }
            catch (IncompatibleClassChangeError | NoClassDefFoundError | SecurityException e) {
                cached2 = EMPTY_FIELD_ARRAY;
            }
            catch (RuntimeException e) {
                if (e.getClass().getName().equals("java.lang.reflect.InaccessibleObjectException")) {
                    cached2 = EMPTY_FIELD_ARRAY;
                }
                throw e;
            }
            allFields.put(aClass, cached2);
        }
        if (cached2 == null) {
            DebugReflectionUtil.$$$reportNull$$$0(1);
        }
        return cached2;
    }

    private static boolean isTrivial(@NotNull Class<?> type2) {
        if (type2 == null) {
            DebugReflectionUtil.$$$reportNull$$$0(2);
        }
        return type2.isPrimitive() || type2 == String.class || type2 == Class.class || type2.isArray() && DebugReflectionUtil.isTrivial(type2.getComponentType());
    }

    private static boolean isInitialized(@NotNull Class<?> root) {
        if (root == null) {
            DebugReflectionUtil.$$$reportNull$$$0(3);
        }
        if (Unsafe_shouldBeInitialized == null) {
            return false;
        }
        boolean isInitialized = false;
        try {
            isInitialized = (Boolean)Unsafe_shouldBeInitialized.invoke(AtomicFieldUpdater.getUnsafe(), root) == false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isInitialized;
    }

    public static boolean walkObjects(int maxDepth, @NotNull Map<Object, String> startRoots, @NotNull Class<?> lookFor, @NotNull Predicate<Object> shouldExamineValue, @NotNull PairProcessor<Object, ? super BackLink> leakProcessor) {
        if (startRoots == null) {
            DebugReflectionUtil.$$$reportNull$$$0(4);
        }
        if (lookFor == null) {
            DebugReflectionUtil.$$$reportNull$$$0(5);
        }
        if (shouldExamineValue == null) {
            DebugReflectionUtil.$$$reportNull$$$0(6);
        }
        if (leakProcessor == null) {
            DebugReflectionUtil.$$$reportNull$$$0(7);
        }
        IntOpenHashSet visited2 = new IntOpenHashSet(100);
        ArrayDeque<2> toVisit = new ArrayDeque<2>(100);
        for (Map.Entry<Object, String> entry : startRoots.entrySet()) {
            Object startRoot = entry.getKey();
            final String description2 = entry.getValue();
            toVisit.addLast(new BackLink(startRoot, null, null){

                @Override
                void print(@NotNull StringBuilder result2) {
                    if (result2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    super.print(result2);
                    result2.append(" (from ").append(description2).append(")");
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/com/intellij/util/ref/DebugReflectionUtil$2", "print"));
                }
            });
        }
        BackLink backLink;
        while ((backLink = (BackLink)toVisit.pollFirst()) != null) {
            if (backLink.depth > maxDepth) continue;
            Object value2 = backLink.value;
            if (lookFor.isAssignableFrom(value2.getClass()) && DebugReflectionUtil.markLeaked(value2) && !leakProcessor.process(value2, backLink)) {
                return false;
            }
            if (!visited2.add(System.identityHashCode(value2))) continue;
            DebugReflectionUtil.queueStronglyReferencedValues(toVisit, value2, shouldExamineValue, backLink);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static void queueStronglyReferencedValues(@NotNull Deque<? super BackLink> queue, @NotNull Object root, @NotNull Predicate<Object> shouldExamineValue, @NotNull BackLink backLink) {
        if (queue == null) {
            DebugReflectionUtil.$$$reportNull$$$0(8);
        }
        if (root == null) {
            DebugReflectionUtil.$$$reportNull$$$0(9);
        }
        if (shouldExamineValue == null) {
            DebugReflectionUtil.$$$reportNull$$$0(10);
        }
        if (backLink == null) {
            DebugReflectionUtil.$$$reportNull$$$0(11);
        }
        Class<?> rootClass = root.getClass();
        for (Field field : DebugReflectionUtil.getAllFields(rootClass)) {
            void value2;
            String fieldName = field.getName();
            if (root instanceof Reference && ("referent".equals(fieldName) || "discovered".equals(fieldName))) continue;
            try {
                Object value22 = field.get(root);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            DebugReflectionUtil.queue(value2, field, backLink, queue, shouldExamineValue);
        }
        if (rootClass.isArray()) {
            try {
                for (Object object : (Object[])root) {
                    DebugReflectionUtil.queue(object, null, backLink, queue, shouldExamineValue);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (root instanceof Class && DebugReflectionUtil.isInitialized((Class)root)) {
            for (Field field : DebugReflectionUtil.getAllFields((Class)root)) {
                if ((field.getModifiers() & 8) == 0) continue;
                try {
                    Object value4 = field.get(null);
                    DebugReflectionUtil.queue(value4, field, backLink, queue, shouldExamineValue);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
    }

    private static void queue(Object value2, Field field, @NotNull BackLink backLink, @NotNull Deque<? super BackLink> queue, @NotNull Predicate<Object> shouldExamineValue) {
        if (backLink == null) {
            DebugReflectionUtil.$$$reportNull$$$0(12);
        }
        if (queue == null) {
            DebugReflectionUtil.$$$reportNull$$$0(13);
        }
        if (shouldExamineValue == null) {
            DebugReflectionUtil.$$$reportNull$$$0(14);
        }
        if (value2 == null || DebugReflectionUtil.isTrivial(value2.getClass())) {
            return;
        }
        if (shouldExamineValue.test(value2)) {
            queue.addLast(new BackLink(value2, field, backLink));
        }
    }

    private static boolean markLeaked(Object leaked) {
        return !(leaked instanceof UserDataHolderEx) || ((UserDataHolderEx)leaked).replace(REPORTED_LEAKED, null, Boolean.TRUE);
    }

    static {
        Method shouldBeInitialized;
        allFields = Collections.synchronizedMap(new Object2ObjectOpenCustomHashMap(new Hash.Strategy<Class<?>>(){

            @Override
            public int hashCode(@Nullable Class<?> aClass) {
                return aClass == null ? 0 : aClass.getName().hashCode();
            }

            @Override
            public boolean equals(@Nullable Class<?> o1, @Nullable Class<?> o2) {
                return o1 == o2;
            }
        }));
        EMPTY_FIELD_ARRAY = new Field[0];
        try {
            shouldBeInitialized = ReflectionUtil.getDeclaredMethod(Class.forName("sun.misc.Unsafe"), "shouldBeInitialized", Class.class);
        }
        catch (ClassNotFoundException ignored) {
            shouldBeInitialized = null;
        }
        Unsafe_shouldBeInitialized = shouldBeInitialized;
        REPORTED_LEAKED = Key.create("REPORTED_LEAKED");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/ref/DebugReflectionUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startRoots";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookFor";
                break;
            }
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shouldExamineValue";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leakProcessor";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backLink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ref/DebugReflectionUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllFields";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isTrivial";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isInitialized";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "walkObjects";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "queueStronglyReferencedValues";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "queue";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class BackLink {
        @NotNull
        private final Object value;
        private final Field field;
        private final BackLink backLink;
        private final int depth;

        BackLink(@NotNull Object value2, @Nullable Field field, @Nullable BackLink backLink) {
            if (value2 == null) {
                BackLink.$$$reportNull$$$0(0);
            }
            this.value = value2;
            this.field = field;
            this.backLink = backLink;
            this.depth = backLink == null ? 0 : backLink.depth + 1;
        }

        public String toString() {
            StringBuilder result2 = new StringBuilder();
            BackLink backLink = this;
            while (backLink != null) {
                backLink.print(result2);
                backLink = backLink.backLink;
            }
            return result2.toString();
        }

        void print(@NotNull StringBuilder result2) {
            String valueStr;
            if (result2 == null) {
                BackLink.$$$reportNull$$$0(1);
            }
            Object value2 = this.value;
            try {
                valueStr = value2 instanceof FList ? "FList (size=" + ((FList)value2).size() + ")" : (value2 instanceof Collection ? "Collection (size=" + ((Collection)value2).size() + ")" : String.valueOf(value2));
                valueStr = StringUtil.first(StringUtil.convertLineSeparators(valueStr, "\\n"), 200, true);
            }
            catch (Throwable e) {
                valueStr = "(" + e.getMessage() + " while computing .toString())";
            }
            Field field = this.field;
            String fieldName = field == null ? "?" : field.getDeclaringClass().getName() + "." + field.getName();
            result2.append("via '").append(fieldName).append("'; Value: '").append(valueStr).append("' of ").append(value2.getClass()).append("\n");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ref/DebugReflectionUtil$BackLink";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "print";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

