/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.js.naming.EncodeSignatureKt;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.SignatureUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"escape", "", "s", "generateSignature", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "js.translator"})
public final class SignatureUtilsKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String generateSignature(@NotNull DeclarationDescriptor descriptor2) {
        String string2;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (DescriptorUtils.isDescriptorWithLocalVisibility(descriptor2)) {
            return null;
        }
        if (descriptor2 instanceof DeclarationDescriptorWithVisibility && Intrinsics.areEqual(((DeclarationDescriptorWithVisibility)descriptor2).getVisibility(), DescriptorVisibilities.PRIVATE) && !AnnotationsUtils.isNativeObject(descriptor2) && !AnnotationsUtils.isLibraryObject(descriptor2)) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor instanceof CallableDescriptor) {
            if (descriptor2 instanceof ConstructorDescriptor && ((ConstructorDescriptor)descriptor2).isPrimary()) {
                ClassDescriptor classDescriptor = ((ConstructorDescriptor)descriptor2).getConstructedClass();
                Intrinsics.checkNotNullExpressionValue(classDescriptor, "descriptor.constructedClass");
                return SignatureUtilsKt.generateSignature(classDescriptor);
            }
            DeclarationDescriptor declarationDescriptor2 = ((CallableDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue(declarationDescriptor2, "descriptor.containingDeclaration");
            String string3 = SignatureUtilsKt.generateSignature(declarationDescriptor2);
            if (string3 == null) {
                return null;
            }
            String parent2 = string3;
            if (!(descriptor2 instanceof VariableAccessorDescriptor) && !(descriptor2 instanceof ConstructorDescriptor) && ((CallableDescriptor)descriptor2).getName().isSpecial()) {
                return null;
            }
            String separator = descriptor2 instanceof FunctionDescriptor ? "#" : "!";
            StringBuilder stringBuilder = new StringBuilder().append(parent2).append(separator);
            String string4 = ((CallableDescriptor)descriptor2).getName().asString();
            Intrinsics.checkNotNullExpressionValue(string4, "descriptor.name.asString()");
            string2 = stringBuilder.append(SignatureUtilsKt.escape(string4)).append('|').append(EncodeSignatureKt.encodeSignature((CallableDescriptor)descriptor2)).toString();
        } else if (declarationDescriptor instanceof PackageFragmentDescriptor) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String string5 = DescriptorUtilsKt.getModule(descriptor2).getName().asString();
            Intrinsics.checkNotNullExpressionValue(string5, "descriptor.module.name.asString()");
            String module2 = string5;
            Object object = new String[]{module2};
            Sequence<String> sequence2 = SequencesKt.sequenceOf(object);
            List<Name> list2 = ((PackageFragmentDescriptor)descriptor2).getFqName().pathSegments();
            Intrinsics.checkNotNullExpressionValue(list2, "descriptor.fqName.pathSegments()");
            object = list2;
            Sequence<String> sequence3 = sequence2;
            boolean $i$f$map = false;
            void var6_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Name name = (Name)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string6 = it.getIdentifier();
                Intrinsics.checkNotNullExpressionValue(string6, "it.identifier");
                collection.add(string6);
            }
            Sequence<String> parts2 = SequencesKt.plus(sequence3, (List)destination$iv$iv);
            string2 = SequencesKt.joinToString$default(parts2, ".", null, null, 0, null, generateSignature.1.INSTANCE, 30, null);
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            DeclarationDescriptor declarationDescriptor3 = ((ClassDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue(declarationDescriptor3, "descriptor.containingDeclaration");
            String string7 = SignatureUtilsKt.generateSignature(declarationDescriptor3);
            if (string7 == null) {
                return null;
            }
            String parent3 = string7;
            if (((ClassDescriptor)descriptor2).getName().isSpecial()) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder().append(parent3).append('$');
            String string8 = ((ClassDescriptor)descriptor2).getName().asString();
            Intrinsics.checkNotNullExpressionValue(string8, "descriptor.name.asString()");
            string2 = stringBuilder.append(SignatureUtilsKt.escape(string8)).toString();
        } else {
            return null;
        }
        return string2;
    }

    private static final String escape(String s) {
        StringBuilder sb = new StringBuilder();
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            char c2 = c;
            String escapedChar = (((((((((((((c2 == '\\' ? true : c2 == '\"') ? true : c2 == '.') ? true : c2 == '$') ? true : c2 == '#') ? true : c2 == '!') ? true : c2 == '<') ? true : c2 == '>') ? true : c2 == '|') ? true : c2 == '+') ? true : c2 == '-') ? true : c2 == ':') ? true : c2 == '*') ? true : c2 == '?') ? "" + '\\' + c : String.valueOf(c);
            sb.append(escapedChar);
        }
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "sb.toString()");
        return string2;
    }

    public static final /* synthetic */ String access$escape(String s) {
        return SignatureUtilsKt.escape(s);
    }
}

