/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.metadata.serialization.StringTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.error.ErrorUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/serialization/DescriptorAwareStringTable;", "Lorg/jetbrains/kotlin/metadata/serialization/StringTable;", "isLocalClassIdReplacementKeptGeneric", "", "()Z", "getFqNameIndex", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptorWithTypeParameters;", "getLocalClassIdReplacement", "Lorg/jetbrains/kotlin/name/ClassId;", "getQualifiedClassNameIndex", "classId", "renderDescriptor", "", "serialization"})
public interface DescriptorAwareStringTable
extends StringTable {
    public int getQualifiedClassNameIndex(@NotNull ClassId var1);

    public int getFqNameIndex(@NotNull ClassifierDescriptorWithTypeParameters var1);

    @Nullable
    public ClassId getLocalClassIdReplacement(@NotNull ClassifierDescriptorWithTypeParameters var1);

    public boolean isLocalClassIdReplacementKeptGeneric();

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static int getQualifiedClassNameIndex(@NotNull DescriptorAwareStringTable $this, @NotNull ClassId classId) {
            Intrinsics.checkNotNullParameter(classId, "classId");
            String string2 = classId.asString();
            Intrinsics.checkNotNullExpressionValue(string2, "classId.asString()");
            return $this.getQualifiedClassNameIndex(string2, classId.isLocal());
        }

        public static int getFqNameIndex(@NotNull DescriptorAwareStringTable $this, @NotNull ClassifierDescriptorWithTypeParameters descriptor2) {
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            if (ErrorUtils.isError(descriptor2)) {
                throw new IllegalStateException("Cannot get FQ name of error class: " + DefaultImpls.renderDescriptor($this, descriptor2));
            }
            ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)descriptor2);
            if (classId == null && (classId = $this.getLocalClassIdReplacement(descriptor2)) == null) {
                throw new IllegalStateException("Cannot get FQ name of local class: " + DefaultImpls.renderDescriptor($this, descriptor2));
            }
            ClassId classId2 = classId;
            return $this.getQualifiedClassNameIndex(classId2);
        }

        @Nullable
        public static ClassId getLocalClassIdReplacement(@NotNull DescriptorAwareStringTable $this, @NotNull ClassifierDescriptorWithTypeParameters descriptor2) {
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            return null;
        }

        public static boolean isLocalClassIdReplacementKeptGeneric(@NotNull DescriptorAwareStringTable $this) {
            return false;
        }

        private static String renderDescriptor(DescriptorAwareStringTable $this, ClassifierDescriptorWithTypeParameters descriptor2) {
            StringBuilder stringBuilder = new StringBuilder().append(DescriptorRenderer.COMPACT.render(descriptor2)).append(" defined in ");
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "descriptor.containingDeclaration");
            return stringBuilder.append(DescriptorRenderer.FQ_NAMES_IN_TYPES.render(declarationDescriptor)).toString();
        }
    }
}

