/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.java;

import java.util.NoSuchElementException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.sonarsource.analyzer.commons.regex.CharacterParser;
import org.sonarsource.analyzer.commons.regex.RegexSource;
import org.sonarsource.analyzer.commons.regex.ast.SourceCharacter;
import org.sonarsource.analyzer.commons.regex.java.JavaUnicodeEscapeParser;

public class JavaCharacterParser
implements CharacterParser {
    private final RegexSource source;
    private final JavaUnicodeEscapeParser unicodeProcessedCharacters;
    @CheckForNull
    private SourceCharacter current;

    public JavaCharacterParser(RegexSource source) {
        this.source = source;
        this.unicodeProcessedCharacters = new JavaUnicodeEscapeParser(source);
        this.moveNext();
    }

    @Override
    public void resetTo(int index2) {
        this.unicodeProcessedCharacters.resetTo(index2);
        this.moveNext();
    }

    @Override
    public void moveNext() {
        this.current = this.parseJavaCharacter();
    }

    @Override
    @Nonnull
    public SourceCharacter getCurrent() {
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        return this.current;
    }

    @Override
    public boolean isAtEnd() {
        return this.current == null;
    }

    @CheckForNull
    private SourceCharacter parseJavaCharacter() {
        SourceCharacter sourceCharacter = this.unicodeProcessedCharacters.getCurrent();
        if (sourceCharacter == null) {
            return null;
        }
        if (sourceCharacter.getCharacter() == '\\') {
            return this.parseJavaEscapeSequence(sourceCharacter);
        }
        this.unicodeProcessedCharacters.moveNext();
        return sourceCharacter;
    }

    private SourceCharacter parseJavaEscapeSequence(SourceCharacter backslash) {
        this.unicodeProcessedCharacters.moveNext();
        SourceCharacter sourceCharacter = this.unicodeProcessedCharacters.getCurrent();
        if (sourceCharacter == null) {
            return backslash;
        }
        char ch = sourceCharacter.getCharacter();
        switch (ch) {
            case 'n': {
                ch = '\n';
                break;
            }
            case 'r': {
                ch = '\r';
                break;
            }
            case 'f': {
                ch = '\f';
                break;
            }
            case 'b': {
                ch = '\b';
                break;
            }
            case 't': {
                ch = '\t';
                break;
            }
            default: {
                int newValue;
                if (!JavaCharacterParser.isOctalDigit(ch)) break;
                ch = '\u0000';
                for (int i = 0; i < 3 && sourceCharacter != null && JavaCharacterParser.isOctalDigit(sourceCharacter.getCharacter()) && (newValue = ch * 8 + sourceCharacter.getCharacter() - 48) <= 255; ++i) {
                    ch = (char)newValue;
                    this.unicodeProcessedCharacters.moveNext();
                    sourceCharacter = this.unicodeProcessedCharacters.getCurrent();
                }
                int endIndex = sourceCharacter == null ? this.source.length() : sourceCharacter.getRange().getBeginningOffset();
                return new SourceCharacter(this.source, backslash.getRange().extendTo(endIndex), ch, true);
            }
        }
        this.unicodeProcessedCharacters.moveNext();
        return new SourceCharacter(this.source, backslash.getRange().merge(sourceCharacter.getRange()), ch, true);
    }

    private static boolean isOctalDigit(int c) {
        return 48 <= c && c <= 55;
    }
}

