/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.types.KotlinType;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.AbstractCheck;
import org.sonarsource.kotlin.api.ApiExtensionsKt;
import org.sonarsource.kotlin.api.CallAbstractCheck;
import org.sonarsource.kotlin.api.FunMatcherImpl;
import org.sonarsource.kotlin.api.SecondaryLocation;
import org.sonarsource.kotlin.checks.AuthorisingNonAuthenticatedUsersCheckKt;
import org.sonarsource.kotlin.converter.KotlinTextRanges;
import org.sonarsource.kotlin.plugin.KotlinFileContext;

@Rule(key="S6288")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/sonarsource/kotlin/checks/AuthorisingNonAuthenticatedUsersCheck;", "Lorg/sonarsource/kotlin/api/CallAbstractCheck;", "()V", "functionsToVisit", "", "Lorg/sonarsource/kotlin/api/FunMatcherImpl;", "getFunctionsToVisit", "()Ljava/util/List;", "visitFunctionCall", "", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "kotlinFileContext", "Lorg/sonarsource/kotlin/plugin/KotlinFileContext;", "sonar-kotlin-plugin"})
public final class AuthorisingNonAuthenticatedUsersCheck
extends CallAbstractCheck {
    @NotNull
    private final List<FunMatcherImpl> functionsToVisit = CollectionsKt.listOf(AuthorisingNonAuthenticatedUsersCheckKt.access$getKEY_GEN_BUILDER_BUILD_MATCHER$p());

    @NotNull
    public List<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull ResolvedCall<?> resolvedCall2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        BindingContext bindingContext2 = kotlinFileContext.getBindingContext();
        Call call2 = CallUtilKt.getCall(callExpression, bindingContext2);
        if (call2 == null) {
            return;
        }
        Call call3 = call2;
        Object receiver = call3;
        List secondaryLocations2 = new ArrayList();
        while (!AuthorisingNonAuthenticatedUsersCheckKt.access$getKEY_GEN_BUILDER_MATCHER$p().matches((Call)receiver, bindingContext2)) {
            KtExpression ktExpression;
            KtCallExpression callElement;
            Object object = receiver.getCallElement();
            if ((object instanceof KtCallExpression ? (KtCallExpression)object : null) == null) {
                return;
            }
            callElement = callElement;
            if (AuthorisingNonAuthenticatedUsersCheckKt.access$getKEY_GEN_BUILDER_SET_AUTH_MATCHER$p().matches((Call)receiver, bindingContext2)) {
                KtExpression argumentExpression;
                ValueArgument valueArgument = receiver.getValueArguments().get(0);
                Intrinsics.checkNotNull(valueArgument != null ? valueArgument.getArgumentExpression() : null);
                argumentExpression = argumentExpression;
                if (CallUtilKt.getType(argumentExpression, bindingContext2) != null) {
                    Boolean argValue;
                    KotlinType it;
                    boolean bl = false;
                    CompileTimeConstant compileTimeConstant = (CompileTimeConstant)bindingContext2.get(BindingContext.COMPILE_TIME_VALUE, argumentExpression);
                    Object var14_14 = compileTimeConstant != null ? compileTimeConstant.getValue(it) : null;
                    Boolean bl2 = argValue = var14_14 instanceof Boolean ? (Boolean)var14_14 : null;
                    if (!Intrinsics.areEqual(argValue, false)) {
                        return;
                    }
                    KtExpression ktExpression2 = callElement.getCalleeExpression();
                    Intrinsics.checkNotNull(ktExpression2);
                    secondaryLocations2.add(new SecondaryLocation(KotlinTextRanges.INSTANCE.textRange(kotlinFileContext, ktExpression2), null, 2, null));
                }
            }
            if ((ktExpression = ApiExtensionsKt.predictReceiverExpression$default(callElement, bindingContext2, null, 2, null)) == null || (object = CallUtilKt.getCall(ktExpression, bindingContext2)) == null) {
                return;
            }
            receiver = object;
        }
        AbstractCheck abstractCheck = this;
        KtExpression ktExpression = receiver.getCalleeExpression();
        Intrinsics.checkNotNull(ktExpression);
        AbstractCheck.reportIssue$sonar_kotlin_plugin$default(abstractCheck, kotlinFileContext, ktExpression, "Make sure authorizing non-authenticated users to use this key is safe here.", secondaryLocations2, null, 8, null);
    }
}

