/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.AbstractCheck;
import org.sonarsource.kotlin.api.ApiExtensionsKt;
import org.sonarsource.kotlin.api.CallAbstractCheck;
import org.sonarsource.kotlin.api.FunMatcherImpl;
import org.sonarsource.kotlin.checks.CollectionInappropriateCallsCheckKt;
import org.sonarsource.kotlin.plugin.KotlinFileContext;

@Rule(key="S2175")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/sonarsource/kotlin/checks/CollectionInappropriateCallsCheck;", "Lorg/sonarsource/kotlin/api/CallAbstractCheck;", "()V", "functionsToVisit", "", "Lorg/sonarsource/kotlin/api/FunMatcherImpl;", "getFunctionsToVisit", "()Ljava/util/List;", "visitFunctionCall", "", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "funMatcherImpl", "kotlinFileContext", "Lorg/sonarsource/kotlin/plugin/KotlinFileContext;", "sonar-kotlin-plugin"})
public final class CollectionInappropriateCallsCheck
extends CallAbstractCheck {
    @NotNull
    private final List<FunMatcherImpl> functionsToVisit;

    public CollectionInappropriateCallsCheck() {
        FunMatcherImpl[] funMatcherImplArray = new FunMatcherImpl[]{CollectionInappropriateCallsCheckKt.getCOLLECTION_EXTENSIONS_MATCHER(), CollectionInappropriateCallsCheckKt.getCOLLECTION_ARGUMENT_EXTENSIONS_MATCHER(), CollectionInappropriateCallsCheckKt.getCONTAINS_VALUE_MATCHER()};
        this.functionsToVisit = CollectionsKt.listOf(funMatcherImplArray);
    }

    @NotNull
    public List<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull ResolvedCall<?> resolvedCall2, @NotNull FunMatcherImpl funMatcherImpl, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(funMatcherImpl, "funMatcherImpl");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        BindingContext ctx = kotlinFileContext.getBindingContext();
        List<KtValueArgument> list2 = callExpression.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(list2, "callExpression.valueArguments");
        KtValueArgument arg = CollectionsKt.first(list2);
        KotlinType kotlinType = ApiExtensionsKt.determineType(arg, ctx);
        if (kotlinType == null) {
            return;
        }
        KotlinType argType = kotlinType;
        KotlinType kotlinType2 = ApiExtensionsKt.determineType(ApiExtensionsKt.predictReceiverExpression$default(callExpression, ctx, null, 2, null), ctx);
        if (kotlinType2 == null) {
            return;
        }
        KotlinType collectionType = kotlinType2;
        Integer n = CollectionInappropriateCallsCheckKt.getFunMatcherToArgumentIndexMap().get(funMatcherImpl);
        Intrinsics.checkNotNull(n);
        int collectionArgumentIndex = ((Number)n).intValue();
        KotlinType kotlinType3 = collectionType.getArguments().get(collectionArgumentIndex).getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType3, "collectionType.arguments\u2026ectionArgumentIndex].type");
        KotlinType collectionArgumentType = TypeUtilsKt.makeNotNullable(kotlinType3);
        if (Intrinsics.areEqual(funMatcherImpl, CollectionInappropriateCallsCheckKt.getCOLLECTION_ARGUMENT_EXTENSIONS_MATCHER())) {
            KotlinType kotlinType4 = CollectionsKt.first(argType.getArguments()).getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType4, "argType.arguments.first().type");
            argType = kotlinType4;
        }
        if (TypeUtilsKt.isTypeParameter(argType = TypeUtilsKt.makeNotNullable(argType)) || TypeUtilsKt.isTypeParameter(collectionArgumentType)) {
            return;
        }
        if (!(Intrinsics.areEqual(argType, collectionArgumentType) || ApiExtensionsKt.isSupertypeOf(collectionArgumentType, argType) || ApiExtensionsKt.isSupertypeOf(argType, collectionArgumentType))) {
            AbstractCheck abstractCheck = this;
            Intrinsics.checkNotNullExpressionValue(arg, "arg");
            AbstractCheck.reportIssue$sonar_kotlin_plugin$default(abstractCheck, kotlinFileContext, arg, CollectionInappropriateCallsCheckKt.getISSUE_MESSAGE(), null, null, 12, null);
        }
    }
}

