/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.AbstractCheck;
import org.sonarsource.kotlin.plugin.KotlinFileContext;

@Rule(key="S126")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010\t\u001a\u00020\n*\u00020\u0006H\u0002J\f\u0010\u000b\u001a\u00020\n*\u00020\u0006H\u0002\u00a8\u0006\f"}, d2={"Lorg/sonarsource/kotlin/checks/ElseIfWithoutElseCheck;", "Lorg/sonarsource/kotlin/api/AbstractCheck;", "()V", "visitIfExpression", "", "ifExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "kotlinFileContext", "Lorg/sonarsource/kotlin/plugin/KotlinFileContext;", "isTopLevelIf", "", "terminates", "sonar-kotlin-plugin"})
public final class ElseIfWithoutElseCheck
extends AbstractCheck {
    @Override
    public void visitIfExpression(@NotNull KtIfExpression ifExpression, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(ifExpression, "ifExpression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (ifExpression.getElse() == null || !this.isTopLevelIf(ifExpression)) {
            return;
        }
        KtIfExpression lastIfExpression = ifExpression;
        boolean allTerminate = this.terminates(lastIfExpression);
        while (lastIfExpression.getElse() instanceof KtIfExpression) {
            KtExpression ktExpression = lastIfExpression.getElse();
            Intrinsics.checkNotNull(ktExpression, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
            lastIfExpression = (KtIfExpression)ktExpression;
            allTerminate = allTerminate && this.terminates(lastIfExpression);
        }
        if (!allTerminate && lastIfExpression.getElse() == null) {
            AbstractCheck abstractCheck = this;
            PsiElement psiElement = lastIfExpression.getIfKeyword();
            Intrinsics.checkNotNullExpressionValue(psiElement, "lastIfExpression.ifKeyword");
            AbstractCheck.reportIssue$sonar_kotlin_plugin$default(abstractCheck, kotlinFileContext, psiElement, "Add the missing \"else\" clause.", null, null, 12, null);
        }
    }

    private final boolean isTopLevelIf(KtIfExpression $this$isTopLevelIf) {
        PsiElement parent2 = $this$isTopLevelIf.getParent().getParent();
        return parent2 instanceof KtIfExpression ? !Intrinsics.areEqual(((KtIfExpression)parent2).getElse(), $this$isTopLevelIf) : true;
    }

    private final boolean terminates(KtIfExpression $this$terminates) {
        KtExpression ktExpression = $this$terminates.getThen();
        Intrinsics.checkNotNull(ktExpression);
        KtExpression ktExpression2 = KtPsiUtilKt.lastBlockStatementOrThis(ktExpression);
        return ((ktExpression2 instanceof KtReturnExpression ? true : ktExpression2 instanceof KtThrowExpression) ? true : ktExpression2 instanceof KtBreakExpression) ? true : ktExpression2 instanceof KtContinueExpression;
    }
}

