/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.AbstractCheck;
import org.sonarsource.kotlin.api.ApiExtensionsKt;
import org.sonarsource.kotlin.checks.EqualsOverridenWithHashCodeCheckKt;
import org.sonarsource.kotlin.plugin.KotlinFileContext;

@Rule(key="S1206")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/sonarsource/kotlin/checks/EqualsOverridenWithHashCodeCheck;", "Lorg/sonarsource/kotlin/api/AbstractCheck;", "()V", "visitClassBody", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClassBody;", "ctx", "Lorg/sonarsource/kotlin/plugin/KotlinFileContext;", "sonar-kotlin-plugin"})
public final class EqualsOverridenWithHashCodeCheck
extends AbstractCheck {
    @Override
    public void visitClassBody(@NotNull KtClassBody klass, @NotNull KotlinFileContext ctx) {
        block7: {
            KtNamedFunction it;
            Intrinsics.checkNotNullParameter(klass, "klass");
            Intrinsics.checkNotNullParameter(ctx, "ctx");
            KtNamedFunction equalsMethod = null;
            KtNamedFunction hashCodeMethod = null;
            Iterable $this$forEach$iv = klass.getFunctions();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtNamedFunction it2 = (KtNamedFunction)element$iv;
                boolean bl = false;
                if (hashCodeMethod == null && EqualsOverridenWithHashCodeCheckKt.access$getHashCodeMatcher$p().matches(it2, ctx.getBindingContext())) {
                    hashCodeMethod = it2;
                } else if (equalsMethod == null && EqualsOverridenWithHashCodeCheckKt.access$getEqualsMatcher$p().matches(it2, ctx.getBindingContext())) {
                    equalsMethod = it2;
                }
                if (hashCodeMethod == null || equalsMethod == null) continue;
                return;
            }
            KtNamedFunction ktNamedFunction = equalsMethod;
            if (ktNamedFunction != null) {
                it = ktNamedFunction;
                boolean bl = false;
                if (!ApiExtensionsKt.isAbstract(it)) {
                    AbstractCheck.reportIssue$sonar_kotlin_plugin$default((AbstractCheck)this, ctx, it, "This class overrides \"equals()\" and should therefore also override \"hashCode()\".", null, null, 12, null);
                }
            }
            KtNamedFunction ktNamedFunction2 = hashCodeMethod;
            if (ktNamedFunction2 == null) break block7;
            it = ktNamedFunction2;
            boolean bl = false;
            if (!ApiExtensionsKt.isAbstract(it)) {
                AbstractCheck.reportIssue$sonar_kotlin_plugin$default((AbstractCheck)this, ctx, it, "This class overrides \"hashCode()\" and should therefore also override \"equals()\".", null, null, 12, null);
            }
        }
    }
}

