/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.List;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.kotlin.api.AbstractCheck;
import org.sonarsource.kotlin.api.SecondaryLocation;
import org.sonarsource.kotlin.checks.CognitiveComplexity;
import org.sonarsource.kotlin.converter.KotlinTextRanges;
import org.sonarsource.kotlin.plugin.KotlinFileContext;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Rule(key="S3776")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/sonarsource/kotlin/checks/FunctionCognitiveComplexityCheck;", "Lorg/sonarsource/kotlin/api/AbstractCheck;", "()V", "threshold", "", "getThreshold", "()I", "setThreshold", "(I)V", "secondaryLocation", "Lorg/sonarsource/kotlin/api/SecondaryLocation;", "increment", "Lorg/sonarsource/kotlin/checks/CognitiveComplexity$Increment;", "context", "Lorg/sonarsource/kotlin/plugin/KotlinFileContext;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "Companion", "sonar-kotlin-plugin"})
public final class FunctionCognitiveComplexityCheck
extends AbstractCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RuleProperty(key="threshold", description="The maximum authorized complexity.", defaultValue="15")
    private int threshold = 15;
    private static final int DEFAULT_THRESHOLD = 15;

    public final int getThreshold() {
        return this.threshold;
    }

    public final void setThreshold(int n) {
        this.threshold = n;
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(context, "context");
        PsiElement psiElement = function2.getNameIdentifier();
        if (psiElement == null) {
            return;
        }
        PsiElement nameIdentifier = psiElement;
        CognitiveComplexity complexity = new CognitiveComplexity(function2);
        int value2 = complexity.value();
        if (value2 > this.threshold) {
            String string2 = "Refactor this method to reduce its Cognitive Complexity from " + value2 + " to the " + this.threshold + " allowed.";
            List<SecondaryLocation> list2 = complexity.increments().stream().map(arg_0 -> FunctionCognitiveComplexityCheck.visitNamedFunction$lambda-0(this, context, arg_0)).collect(Collectors.toList());
            Intrinsics.checkNotNullExpressionValue(list2, "complexity.increments().\u2026lect(Collectors.toList())");
            this.reportIssue$sonar_kotlin_plugin(context, nameIdentifier, string2, list2, (Double)((double)value2 - (double)this.threshold));
        }
    }

    private final SecondaryLocation secondaryLocation(CognitiveComplexity.Increment increment, KotlinFileContext context) {
        int nestingLevel = increment.getNestingLevel();
        String message = "+" + (nestingLevel + 1);
        if (nestingLevel > 0) {
            message = message + " (incl " + nestingLevel + " for nesting)";
        }
        TextRange textRange2 = KotlinTextRanges.INSTANCE.textRange(context, increment.getToken());
        return new SecondaryLocation(textRange2, message);
    }

    private static final SecondaryLocation visitNamedFunction$lambda-0(FunctionCognitiveComplexityCheck this$0, KotlinFileContext $context, CognitiveComplexity.Increment increment) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($context, "$context");
        Intrinsics.checkNotNullParameter(increment, "increment");
        return this$0.secondaryLocation(increment, $context);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/sonarsource/kotlin/checks/FunctionCognitiveComplexityCheck$Companion;", "", "()V", "DEFAULT_THRESHOLD", "", "sonar-kotlin-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

