/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0012"}, d2={"Lorg/sonarsource/kotlin/checks/InsecureAlgorithm;", "", "(Ljava/lang/String;I)V", "match", "", "algorithm", "", "MD2", "MD4", "MD5", "MD6", "RIPEMD", "HAVAL128", "SHA1", "SHA0", "SHA224", "SHA", "DSA", "sonar-kotlin-plugin"})
public class InsecureAlgorithm
extends Enum<InsecureAlgorithm> {
    public static final /* enum */ InsecureAlgorithm MD2 = new InsecureAlgorithm();
    public static final /* enum */ InsecureAlgorithm MD4 = new InsecureAlgorithm();
    public static final /* enum */ InsecureAlgorithm MD5 = new InsecureAlgorithm();
    public static final /* enum */ InsecureAlgorithm MD6 = new InsecureAlgorithm();
    public static final /* enum */ InsecureAlgorithm RIPEMD = new InsecureAlgorithm();
    public static final /* enum */ InsecureAlgorithm HAVAL128 = new InsecureAlgorithm();
    public static final /* enum */ InsecureAlgorithm SHA1 = new InsecureAlgorithm();
    public static final /* enum */ InsecureAlgorithm SHA0 = new InsecureAlgorithm();
    public static final /* enum */ InsecureAlgorithm SHA224 = new InsecureAlgorithm();
    public static final /* enum */ InsecureAlgorithm SHA = new SHA("SHA", 9);
    public static final /* enum */ InsecureAlgorithm DSA = new DSA("DSA", 10);
    private static final /* synthetic */ InsecureAlgorithm[] $VALUES;

    private InsecureAlgorithm() {
    }

    public boolean match(@NotNull String algorithm) {
        Intrinsics.checkNotNullParameter(algorithm, "algorithm");
        String string2 = StringsKt.replace$default(algorithm, "-", "", false, 4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        String normalizedName = string2;
        CharSequence charSequence = normalizedName;
        String string3 = this.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        return StringsKt.contains$default(charSequence, string3, false, 2, null);
    }

    public static InsecureAlgorithm[] values() {
        return (InsecureAlgorithm[])$VALUES.clone();
    }

    public static InsecureAlgorithm valueOf(String value2) {
        return Enum.valueOf(InsecureAlgorithm.class, value2);
    }

    public /* synthetic */ InsecureAlgorithm(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        $VALUES = insecureAlgorithmArray = new InsecureAlgorithm[]{InsecureAlgorithm.MD2, InsecureAlgorithm.MD4, InsecureAlgorithm.MD5, InsecureAlgorithm.MD6, InsecureAlgorithm.RIPEMD, InsecureAlgorithm.HAVAL128, InsecureAlgorithm.SHA1, InsecureAlgorithm.SHA0, InsecureAlgorithm.SHA224, InsecureAlgorithm.SHA, InsecureAlgorithm.DSA};
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/sonarsource/kotlin/checks/InsecureAlgorithm$SHA;", "Lorg/sonarsource/kotlin/checks/InsecureAlgorithm;", "match", "", "algorithm", "", "sonar-kotlin-plugin"})
    static final class SHA
    extends InsecureAlgorithm {
        /*
         * WARNING - void declaration
         */
        SHA() {
            void var1_1;
        }

        @Override
        public boolean match(@NotNull String algorithm) {
            Intrinsics.checkNotNullParameter(algorithm, "algorithm");
            return StringsKt.equals(algorithm, "sha", true);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/sonarsource/kotlin/checks/InsecureAlgorithm$DSA;", "Lorg/sonarsource/kotlin/checks/InsecureAlgorithm;", "match", "", "algorithm", "", "sonar-kotlin-plugin"})
    static final class DSA
    extends InsecureAlgorithm {
        /*
         * WARNING - void declaration
         */
        DSA() {
            void var1_1;
        }

        @Override
        public boolean match(@NotNull String algorithm) {
            Intrinsics.checkNotNullParameter(algorithm, "algorithm");
            return StringsKt.equals(algorithm, "dsa", true);
        }
    }
}

