/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.AbstractCheck;
import org.sonarsource.kotlin.api.ApiExtensionsKt;
import org.sonarsource.kotlin.checks.StrongCipherAlgorithmCheckKt;
import org.sonarsource.kotlin.plugin.KotlinFileContext;

@Rule(key="S5547")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/sonarsource/kotlin/checks/StrongCipherAlgorithmCheck;", "Lorg/sonarsource/kotlin/api/AbstractCheck;", "()V", "visitCallExpression", "", "callExpr", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "kotlinFileContext", "Lorg/sonarsource/kotlin/plugin/KotlinFileContext;", "sonar-kotlin-plugin"})
public final class StrongCipherAlgorithmCheck
extends AbstractCheck {
    @Override
    public void visitCallExpression(@NotNull KtCallExpression callExpr, @NotNull KotlinFileContext kotlinFileContext) {
        block10: {
            BindingContext bindingContext2;
            block9: {
                Intrinsics.checkNotNullParameter(callExpr, "callExpr");
                Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
                bindingContext2 = kotlinFileContext.component3();
                if (!StrongCipherAlgorithmCheckKt.access$getNullCipherConstructorMatcher$p().matches(callExpr, bindingContext2)) break block9;
                AbstractCheck.reportIssue$sonar_kotlin_plugin$default((AbstractCheck)this, kotlinFileContext, callExpr, "Use a strong cipher algorithm.", null, null, 12, null);
                break block10;
            }
            if (!StrongCipherAlgorithmCheckKt.access$getCipherGetInstanceMatcher$p().matches(callExpr, bindingContext2)) break block10;
            List<KtValueArgument> list2 = callExpr.getValueArguments();
            Intrinsics.checkNotNullExpressionValue(list2, "callExpr.valueArguments");
            KtValueArgument ktValueArgument = CollectionsKt.firstOrNull(list2);
            if (ktValueArgument != null) {
                KtValueArgument arg = ktValueArgument;
                boolean bl = false;
                KtExpression ktExpression = arg.getArgumentExpression();
                Object object = ktExpression;
                if (object != null) {
                    Intrinsics.checkNotNullExpressionValue(object, "getArgumentExpression()");
                    object = ApiExtensionsKt.predictRuntimeStringValue(ktExpression, bindingContext2);
                    if (object != null) {
                        String string2 = ((String)object).toUpperCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toUpperCase(Locale.ROOT)");
                        object = string2;
                        if (string2 != null) {
                            boolean bl2;
                            block8: {
                                Object candidateString = object;
                                boolean bl3 = false;
                                Iterable $this$any$iv = StrongCipherAlgorithmCheckKt.access$getWeakCiphers$p();
                                boolean $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl2 = false;
                                } else {
                                    for (Object element$iv : $this$any$iv) {
                                        String cipher = (String)element$iv;
                                        boolean bl4 = false;
                                        if (!(Intrinsics.areEqual(candidateString, cipher) || StringsKt.startsWith$default((String)candidateString, cipher + "/", false, 2, null))) continue;
                                        bl2 = true;
                                        break block8;
                                    }
                                    bl2 = false;
                                }
                            }
                            if (bl2) {
                                AbstractCheck.reportIssue$sonar_kotlin_plugin$default((AbstractCheck)this, kotlinFileContext, arg, "Use a strong cipher algorithm.", null, null, 12, null);
                            }
                        }
                    }
                }
            }
        }
    }
}

