/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.AbstractCheck;
import org.sonarsource.kotlin.api.ApiExtensionsKt;
import org.sonarsource.kotlin.api.FunMatcherImpl;
import org.sonarsource.kotlin.api.FunMatcherKt;
import org.sonarsource.kotlin.checks.UnencryptedDatabaseOnMobileCheckKt;
import org.sonarsource.kotlin.plugin.KotlinFileContext;

@Rule(key="S6291")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/sonarsource/kotlin/checks/UnencryptedDatabaseOnMobileCheck;", "Lorg/sonarsource/kotlin/api/AbstractCheck;", "()V", "visitCallExpression", "", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "kotlinFileContext", "Lorg/sonarsource/kotlin/plugin/KotlinFileContext;", "sonar-kotlin-plugin"})
public final class UnencryptedDatabaseOnMobileCheck
extends AbstractCheck {
    @Override
    public void visitCallExpression(@NotNull KtCallExpression callExpression, @NotNull KotlinFileContext kotlinFileContext) {
        boolean bl;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2;
        BindingContext bindingContext2;
        block7: {
            Intrinsics.checkNotNullParameter(callExpression, "callExpression");
            Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
            bindingContext2 = kotlinFileContext.getBindingContext();
            resolvedCall2 = CallUtilKt.getResolvedCall(callExpression, bindingContext2);
            Iterable $this$any$iv = UnencryptedDatabaseOnMobileCheckKt.access$getPROBLEMATIC_SIMPLE_CALLS$p();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FunMatcherImpl it = (FunMatcherImpl)element$iv;
                    boolean bl2 = false;
                    if (!FunMatcherKt.matches(resolvedCall2, it)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            AbstractCheck abstractCheck = this;
            KtExpression ktExpression = callExpression.getCalleeExpression();
            Intrinsics.checkNotNull(ktExpression);
            AbstractCheck.reportIssue$sonar_kotlin_plugin$default(abstractCheck, kotlinFileContext, ktExpression, "Make sure using an unencrypted database is safe here.", null, null, 12, null);
        } else if (FunMatcherKt.matches(resolvedCall2, UnencryptedDatabaseOnMobileCheckKt.access$getPROBLEMATIC_REALM_CALL$p())) {
            Call call2 = CallUtilKt.getCall(callExpression, bindingContext2);
            if ((call2 != null ? ApiExtensionsKt.findCallInPrecedingCallChain(call2, UnencryptedDatabaseOnMobileCheckKt.access$getREALM_ENC_KEY_FUN$p(), bindingContext2) : null) == null) {
                AbstractCheck abstractCheck = this;
                KtExpression ktExpression = callExpression.getCalleeExpression();
                Intrinsics.checkNotNull(ktExpression);
                AbstractCheck.reportIssue$sonar_kotlin_plugin$default(abstractCheck, kotlinFileContext, ktExpression, "Make sure using an unencrypted database is safe here.", null, null, 12, null);
            }
        }
    }
}

