/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.AbstractCheck;
import org.sonarsource.kotlin.api.ApiExtensionsKt;
import org.sonarsource.kotlin.api.SecondaryLocation;
import org.sonarsource.kotlin.checks.UnusedFunctionParameterCheckKt;
import org.sonarsource.kotlin.converter.KotlinTextRanges;
import org.sonarsource.kotlin.plugin.KotlinFileContext;

@Rule(key="S1172")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/sonarsource/kotlin/checks/UnusedFunctionParameterCheck;", "Lorg/sonarsource/kotlin/api/AbstractCheck;", "()V", "reportUnusedParameters", "", "context", "Lorg/sonarsource/kotlin/plugin/KotlinFileContext;", "unusedParameters", "", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "singleMessage", "", "pluralMessage", "visitLambdaExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "sonar-kotlin-plugin"})
public final class UnusedFunctionParameterCheck
extends AbstractCheck {
    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!UnusedFunctionParameterCheckKt.access$shouldBeChecked(function2)) {
            return;
        }
        List unusedParameters = UnusedFunctionParameterCheckKt.access$getUnusedParameters(function2);
        String singleMessage = ApiExtensionsKt.isAnonymous(function2) ? "Use \"_\" instead of this unused function parameter" : "Remove this unused function parameter";
        String pluralMessage = ApiExtensionsKt.isAnonymous(function2) ? "Use \"_\" instead of these unused function parameters." : "Remove these unused function parameters.";
        if (!((Collection)unusedParameters).isEmpty()) {
            this.reportUnusedParameters(context, unusedParameters, singleMessage, pluralMessage);
        }
    }

    @Override
    public void visitLambdaExpression(@NotNull KtLambdaExpression expression2, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        List unusedParameters = UnusedFunctionParameterCheckKt.access$getUnusedParameters(expression2);
        String singleMessage = "Use \"_\" instead of this unused lambda parameter";
        String pluralMessage = "Use \"_\" instead of these unused lambda parameters.";
        if (!((Collection)unusedParameters).isEmpty()) {
            this.reportUnusedParameters(context, unusedParameters, singleMessage, pluralMessage);
        }
    }

    private final void reportUnusedParameters(KotlinFileContext context, List<? extends KtNamedDeclaration> unusedParameters, String singleMessage, String pluralMessage) {
        KtNamedDeclaration firstUnused = unusedParameters.get(0);
        List secondaryLocations2 = SequencesKt.toList(SequencesKt.map(CollectionsKt.asSequence((Iterable)unusedParameters), (Function1)new Function1<KtNamedDeclaration, SecondaryLocation>(context, singleMessage){
            final /* synthetic */ KotlinFileContext $context;
            final /* synthetic */ String $singleMessage;
            {
                this.$context = $context;
                this.$singleMessage = $singleMessage;
                super(1);
            }

            @NotNull
            public final SecondaryLocation invoke(@NotNull KtNamedDeclaration unusedParameter) {
                Intrinsics.checkNotNullParameter(unusedParameter, "unusedParameter");
                PsiElement psiElement = unusedParameter.getNameIdentifier();
                Intrinsics.checkNotNull(psiElement);
                return new SecondaryLocation(KotlinTextRanges.INSTANCE.textRange(this.$context, psiElement), this.$singleMessage + " \"" + unusedParameter.getName() + "\".");
            }
        }));
        if (unusedParameters.size() > 1) {
            AbstractCheck abstractCheck = this;
            PsiElement psiElement = firstUnused.getNameIdentifier();
            Intrinsics.checkNotNull(psiElement);
            AbstractCheck.reportIssue$sonar_kotlin_plugin$default(abstractCheck, context, psiElement, pluralMessage, secondaryLocations2, null, 8, null);
        } else {
            AbstractCheck abstractCheck = this;
            PsiElement psiElement = firstUnused.getNameIdentifier();
            Intrinsics.checkNotNull(psiElement);
            AbstractCheck.reportIssue$sonar_kotlin_plugin$default(abstractCheck, context, psiElement, singleMessage + " \"" + firstUnused.getName() + "\".", null, null, 12, null);
        }
    }
}

