/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.kotlin.api.AbstractCheck;
import org.sonarsource.kotlin.plugin.KotlinFileContext;

@Rule(key="S117")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 #2\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010!\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\"2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/sonarsource/kotlin/checks/VariableAndParameterNameCheck;", "Lorg/sonarsource/kotlin/api/AbstractCheck;", "()V", "format", "", "getFormat", "()Ljava/lang/String;", "setFormat", "(Ljava/lang/String;)V", "formatRegex", "Lkotlin/text/Regex;", "check", "", "kind", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "kotlinFileContext", "Lorg/sonarsource/kotlin/plugin/KotlinFileContext;", "initialize", "ruleKey", "Lorg/sonar/api/rule/RuleKey;", "visitLambdaExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitPrimaryConstructor", "constructor", "Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitSecondaryConstructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "Companion", "sonar-kotlin-plugin"})
public final class VariableAndParameterNameCheck
extends AbstractCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RuleProperty(key="format", description="Regular expression used to check the names against.", defaultValue="^`?[_a-z][a-zA-Z0-9]*`?$")
    @NotNull
    private String format = "^`?[_a-z][a-zA-Z0-9]*`?$";
    private Regex formatRegex;
    @NotNull
    public static final String DEFAULT_FORMAT = "^`?[_a-z][a-zA-Z0-9]*`?$";

    @NotNull
    public final String getFormat() {
        return this.format;
    }

    public final void setFormat(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "<set-?>");
        this.format = string2;
    }

    @Override
    public void initialize(@NotNull RuleKey ruleKey) {
        Intrinsics.checkNotNullParameter(ruleKey, "ruleKey");
        super.initialize(ruleKey);
        this.formatRegex = new Regex(this.format);
    }

    @Override
    public void visitPrimaryConstructor(@NotNull KtPrimaryConstructor constructor, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(constructor, "constructor");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        Iterable $this$forEach$iv = constructor.getValueParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtParameter it = (KtParameter)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            this.check("parameter", it, kotlinFileContext);
        }
    }

    @Override
    public void visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(constructor, "constructor");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        Iterable $this$forEach$iv = constructor.getValueParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtParameter it = (KtParameter)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            this.check("parameter", it, kotlinFileContext);
        }
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        List<KtParameter> list2 = function2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "function.valueParameters");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtParameter it = (KtParameter)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            this.check("parameter", it, kotlinFileContext);
        }
    }

    @Override
    public void visitProperty(@NotNull KtProperty property, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(property, "property");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (property.isLocal()) {
            this.check("local variable", property, kotlinFileContext);
        }
    }

    @Override
    public void visitLambdaExpression(@NotNull KtLambdaExpression expression2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        List<KtParameter> list2 = expression2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "expression.valueParameters");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtParameter it = (KtParameter)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            this.check("parameter", it, kotlinFileContext);
        }
    }

    private final void check(String kind, KtNamedDeclaration declaration, KotlinFileContext kotlinFileContext) {
        PsiElement psiElement = declaration.getNameIdentifier();
        String string2 = psiElement != null ? psiElement.getText() : null;
        if (string2 == null) {
            return;
        }
        String name = string2;
        CharSequence charSequence = name;
        Regex regex = this.formatRegex;
        if (regex == null) {
            Intrinsics.throwUninitializedPropertyAccessException("formatRegex");
            regex = null;
        }
        if (!regex.matches(charSequence)) {
            AbstractCheck abstractCheck = this;
            PsiElement psiElement2 = declaration.getNameIdentifier();
            Intrinsics.checkNotNull(psiElement2);
            AbstractCheck.reportIssue$sonar_kotlin_plugin$default(abstractCheck, kotlinFileContext, psiElement2, "Rename this " + kind + " to match the regular expression " + this.format, null, null, 12, null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/sonarsource/kotlin/checks/VariableAndParameterNameCheck$Companion;", "", "()V", "DEFAULT_FORMAT", "", "sonar-kotlin-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

