/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.dev;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.sonarsource.kotlin.dev.AstPrinterKt;
import org.sonarsource.kotlin.dev.TextPointer;
import org.sonarsource.kotlin.dev.TextRange;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\b\u0018\u0000 $2\u00020\u0001:\u0001$B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00000\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00000\u0007H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\tH\u00c6\u0003JC\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00000\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020\u000eH\u00d6\u0001J\u0006\u0010!\u001a\u00020\u0003J\t\u0010\"\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010#\u001a\u00020\u0003R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014\u00a8\u0006%"}, d2={"Lorg/sonarsource/kotlin/dev/DotNode;", "", "title", "", "text", "type", "children", "", "range", "Lorg/sonarsource/kotlin/dev/TextRange;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lorg/sonarsource/kotlin/dev/TextRange;)V", "getChildren", "()Ljava/util/List;", "id", "", "getId", "()I", "getRange", "()Lorg/sonarsource/kotlin/dev/TextRange;", "getText", "()Ljava/lang/String;", "getTitle", "getType", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "htmlLabel", "toString", "txtLabel", "Companion", "sonar-kotlin-plugin"})
public final class DotNode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String title;
    @NotNull
    private final String text;
    @NotNull
    private final String type;
    @NotNull
    private final List<DotNode> children;
    @Nullable
    private final TextRange range;
    private final int id;
    private static int nextId;

    public DotNode(@NotNull String title, @NotNull String text, @NotNull String type2, @NotNull List<DotNode> children2, @Nullable TextRange range) {
        Intrinsics.checkNotNullParameter(title, "title");
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(children2, "children");
        this.title = title;
        this.text = text;
        this.type = type2;
        this.children = children2;
        this.range = range;
        int n = nextId;
        nextId = n + 1;
        this.id = n;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @NotNull
    public final List<DotNode> getChildren() {
        return this.children;
    }

    @Nullable
    public final TextRange getRange() {
        return this.range;
    }

    public final int getId() {
        return this.id;
    }

    @NotNull
    public final String htmlLabel() {
        return (String)(!StringsKt.isBlank(this.title) ? "<i>" + AstPrinterKt.access$escapeHtml(this.title) + "</i><br/>" : "") + AstPrinterKt.access$escapeHtml(this.text);
    }

    @NotNull
    public final String txtLabel() {
        return "[" + this.title + "] " + this.text;
    }

    @NotNull
    public final String component1() {
        return this.title;
    }

    @NotNull
    public final String component2() {
        return this.text;
    }

    @NotNull
    public final String component3() {
        return this.type;
    }

    @NotNull
    public final List<DotNode> component4() {
        return this.children;
    }

    @Nullable
    public final TextRange component5() {
        return this.range;
    }

    @NotNull
    public final DotNode copy(@NotNull String title, @NotNull String text, @NotNull String type2, @NotNull List<DotNode> children2, @Nullable TextRange range) {
        Intrinsics.checkNotNullParameter(title, "title");
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(children2, "children");
        return new DotNode(title, text, type2, children2, range);
    }

    public static /* synthetic */ DotNode copy$default(DotNode dotNode, String string2, String string3, String string4, List list2, TextRange textRange2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = dotNode.title;
        }
        if ((n & 2) != 0) {
            string3 = dotNode.text;
        }
        if ((n & 4) != 0) {
            string4 = dotNode.type;
        }
        if ((n & 8) != 0) {
            list2 = dotNode.children;
        }
        if ((n & 0x10) != 0) {
            textRange2 = dotNode.range;
        }
        return dotNode.copy(string2, string3, string4, list2, textRange2);
    }

    @NotNull
    public String toString() {
        return "DotNode(title=" + this.title + ", text=" + this.text + ", type=" + this.type + ", children=" + this.children + ", range=" + this.range + ")";
    }

    public int hashCode() {
        int result2 = this.title.hashCode();
        result2 = result2 * 31 + this.text.hashCode();
        result2 = result2 * 31 + this.type.hashCode();
        result2 = result2 * 31 + ((Object)this.children).hashCode();
        result2 = result2 * 31 + (this.range == null ? 0 : this.range.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DotNode)) {
            return false;
        }
        DotNode dotNode = (DotNode)other;
        if (!Intrinsics.areEqual(this.title, dotNode.title)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.text, dotNode.text)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.type, dotNode.type)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.children, dotNode.children)) {
            return false;
        }
        return Intrinsics.areEqual(this.range, dotNode.range);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lorg/sonarsource/kotlin/dev/DotNode$Companion;", "", "()V", "nextId", "", "getNextId", "()I", "setNextId", "(I)V", "of", "Lorg/sonarsource/kotlin/dev/DotNode;", "original", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "document", "Lorg/jetbrains/kotlin/com/intellij/openapi/editor/Document;", "sonar-kotlin-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final int getNextId() {
            return nextId;
        }

        public final void setNextId(int n) {
            nextId = n;
        }

        @NotNull
        public final DotNode of(@NotNull PsiElement original, @Nullable Document document) {
            TextRange textRange2;
            Object object;
            String string2;
            Intrinsics.checkNotNullParameter(original, "original");
            PsiElement psiElement = original;
            if (psiElement instanceof KtFile) {
                String string3 = ((KtFile)original).getName();
                Intrinsics.checkNotNullExpressionValue(string3, "original.name");
                string2 = StringsKt.substringAfterLast$default(string3, File.separatorChar, null, 2, null);
            } else if (psiElement instanceof LeafPsiElement) {
                String string4 = ((LeafPsiElement)original).getElementType().toString();
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue(string4, "original.elementType.toString()");
            } else {
                string2 = "";
            }
            String title = string2;
            String string5 = original.getText();
            Intrinsics.checkNotNullExpressionValue(string5, "original.text");
            String $this$of_u24lambda_u2d0 = ((Object)StringsKt.trim((CharSequence)string5)).toString();
            boolean bl = false;
            if ($this$of_u24lambda_u2d0.length() <= 65) {
                object = $this$of_u24lambda_u2d0;
            } else {
                String string6 = $this$of_u24lambda_u2d0.substring(0, 30);
                Intrinsics.checkNotNullExpressionValue(string6, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                String string7 = $this$of_u24lambda_u2d0.substring($this$of_u24lambda_u2d0.length() - 30);
                Intrinsics.checkNotNullExpressionValue(string7, "this as java.lang.String).substring(startIndex)");
                object = string6 + " \u2026 " + string7;
            }
            String text = StringsKt.replace$default((String)object, "\n", "", false, 4, null);
            Document document2 = document;
            if (document2 != null) {
                Document it = document2;
                boolean bl2 = false;
                TextPointer start = AstPrinterKt.textPointerAtOffset(it, PsiUtilsKt.getStartOffset(original));
                TextPointer end = AstPrinterKt.textPointerAtOffset(it, PsiUtilsKt.getEndOffset(original));
                textRange2 = new TextRange(start, end);
            } else {
                textRange2 = null;
            }
            TextRange range = textRange2;
            String string8 = original.getClass().getSimpleName();
            Intrinsics.checkNotNullExpressionValue(string8, "original::class.java.simpleName");
            return new DotNode(title, text, string8, SequencesKt.toList(SequencesKt.map(PsiUtilsKt.getAllChildren(original), (Function1)new Function1<PsiElement, DotNode>(document){
                final /* synthetic */ Document $document;
                {
                    this.$document = $document;
                    super(1);
                }

                @NotNull
                public final DotNode invoke(@NotNull PsiElement it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return DotNode.Companion.of(it, this.$document);
                }
            })), range);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

