/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.plugin;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenEntry;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/sonarsource/kotlin/plugin/CyclomaticComplexityVisitor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "()V", "complexityTrees", "", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "", "visitBinaryExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitIfExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "visitLoopExpression", "loopExpression", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitWhenEntry", "whenEntry", "Lorg/jetbrains/kotlin/psi/KtWhenEntry;", "sonar-kotlin-plugin"})
public final class CyclomaticComplexityVisitor
extends KtTreeVisitorVoid {
    @NotNull
    private final List<PsiElement> complexityTrees = new ArrayList();

    @NotNull
    public final List<PsiElement> complexityTrees() {
        return CollectionsKt.toList((Iterable)this.complexityTrees);
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        if (function2.hasBody() && function2.getName() != null) {
            this.complexityTrees.add(function2);
        }
        super.visitNamedFunction(function2);
    }

    @Override
    public void visitIfExpression(@NotNull KtIfExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        PsiElement psiElement = expression2.getIfKeyword();
        Intrinsics.checkNotNullExpressionValue(psiElement, "expression.ifKeyword");
        this.complexityTrees.add(psiElement);
        super.visitIfExpression(expression2);
    }

    @Override
    public void visitLoopExpression(@NotNull KtLoopExpression loopExpression) {
        Intrinsics.checkNotNullParameter(loopExpression, "loopExpression");
        this.complexityTrees.add(loopExpression);
        super.visitLoopExpression(loopExpression);
    }

    @Override
    public void visitWhenEntry(@NotNull KtWhenEntry whenEntry) {
        Intrinsics.checkNotNullParameter(whenEntry, "whenEntry");
        this.complexityTrees.add(whenEntry);
        super.visitWhenEntry(whenEntry);
    }

    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (Intrinsics.areEqual(expression2.getOperationToken(), KtTokens.ANDAND) || Intrinsics.areEqual(expression2.getOperationToken(), KtTokens.OROR)) {
            this.complexityTrees.add(expression2);
        }
        super.visitBinaryExpression(expression2);
    }
}

