/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.plugin.surefire;

import java.io.File;
import java.util.List;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.Configuration;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.kotlin.plugin.surefire.KotlinSurefireParser;
import org.sonarsource.kotlin.plugin.surefire.api.SurefireUtils;

public class KotlinSurefireSensor
implements Sensor {
    private static final Logger LOGGER = Loggers.get(KotlinSurefireSensor.class);
    private final KotlinSurefireParser kotlinSurefireParser;
    private final Configuration settings;
    private final PathResolver pathResolver;

    public KotlinSurefireSensor(KotlinSurefireParser kotlinSurefireParser, Configuration settings, PathResolver pathResolver) {
        this.kotlinSurefireParser = kotlinSurefireParser;
        this.settings = settings;
        this.pathResolver = pathResolver;
    }

    public void describe(SensorDescriptor descriptor2) {
        descriptor2.onlyOnLanguage("kotlin").name("KotlinSurefireSensor");
    }

    public void execute(SensorContext context) {
        List<File> dirs = SurefireUtils.getReportsDirectories(this.settings, context.fileSystem(), this.pathResolver);
        this.collect(context, dirs);
    }

    protected void collect(SensorContext context, List<File> reportsDirs) {
        LOGGER.info("parsing {}", reportsDirs);
        this.kotlinSurefireParser.collect(context, reportsDirs, this.settings.hasKey("sonar.junit.reportPaths"));
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

