/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.plugins.xml.Utils;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.sonarsource.analyzer.commons.xml.XmlTextRange;
import org.sonarsource.analyzer.commons.xml.checks.SonarXmlCheck;

@Rule(key="S105")
@DeprecatedRuleKey(ruleKey="IllegalTabCheck", repositoryKey="xml")
public class TabCharacterCheck
extends SonarXmlCheck {
    public static final String RULE_KEY = "S105";
    private static final Pattern TABS_REGEX = Pattern.compile("\t++");
    private static final int MAX_REPORTED_LOCATION = 21;

    @Override
    public void scanFile(XmlFile file) {
        String content = file.getContents();
        if (content.indexOf(9) == -1) {
            return;
        }
        String[] lines = Utils.splitLines(content);
        ArrayList<XmlTextRange> firstTabLocations = new ArrayList<XmlTextRange>();
        int extraTabsCount = 0;
        for (int lineNumber = 1; lineNumber <= lines.length; ++lineNumber) {
            String line = lines[lineNumber - 1];
            Matcher tabsMatcher = TABS_REGEX.matcher(line);
            while (tabsMatcher.find()) {
                if (firstTabLocations.size() < 21) {
                    firstTabLocations.add(new XmlTextRange(lineNumber, tabsMatcher.start(), lineNumber, tabsMatcher.end()));
                    continue;
                }
                extraTabsCount += tabsMatcher.end() - tabsMatcher.start();
            }
        }
        this.reportIssue(firstTabLocations, extraTabsCount);
    }

    private void reportIssue(List<XmlTextRange> firstTabLocations, int extraTabsCount) {
        XmlTextRange primaryLocation = firstTabLocations.get(0);
        ArrayList<SonarXmlCheck.Secondary> secondaries = new ArrayList<SonarXmlCheck.Secondary>();
        for (int i = 1; i < firstTabLocations.size(); ++i) {
            XmlTextRange range = firstTabLocations.get(i);
            boolean limitReached = i == 20;
            secondaries.add(new SonarXmlCheck.Secondary(range, "tab character(s)" + (limitReached && extraTabsCount > 0 ? " (and " + extraTabsCount + " more in this file)" : "")));
        }
        this.reportIssue(primaryLocation, "Replace all tab characters in this file by sequences of white-spaces.", secondaries);
    }
}

