/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

public class XPathBuilder {
    private static final XPathFactory FACTORY = XPathFactory.newInstance();
    private final String expression;
    private final XPathContext namespaceContext = new XPathContext();

    private XPathBuilder(String expression) {
        this.expression = expression;
    }

    public static XPathBuilder forExpression(String expression) {
        return new XPathBuilder(expression);
    }

    public XPathBuilder withNamespace(String prefix, String namespaceURI) {
        this.namespaceContext.add(prefix, namespaceURI);
        return this;
    }

    public XPathExpression build() {
        try {
            XPath xpath = FACTORY.newXPath();
            xpath.setNamespaceContext(this.namespaceContext);
            return xpath.compile(this.expression);
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException("Failed to compile XPath expression [" + this.expression + "]: " + e.getMessage(), e);
        }
    }

    static class XPathContext
    implements NamespaceContext {
        private final Map<String, String> namespaceByPrefixMap = new HashMap<String, String>();

        XPathContext() {
        }

        void add(String prefix, String namespaceURI) {
            this.namespaceByPrefixMap.put(prefix, namespaceURI);
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return this.namespaceByPrefixMap.getOrDefault(prefix, "");
        }

        @Override
        public String getPrefix(String namespaceURI) {
            throw new UnsupportedOperationException("Only provides 'getNamespaceURI(prefix)' conversion");
        }

        @Override
        public Iterator<String> getPrefixes(String namespaceURI) {
            throw new UnsupportedOperationException("Only provides 'getNamespaceURI(prefix)' conversion");
        }
    }
}

