/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.flex;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.impl.Parser;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.sonar.api.SonarProduct;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.Version;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexVisitorContext;
import org.sonar.flex.Issue;
import org.sonar.flex.checks.CheckList;
import org.sonar.flex.lexer.FlexLexer;
import org.sonar.flex.metrics.ComplexityVisitor;
import org.sonar.flex.metrics.FileMetrics;
import org.sonar.flex.parser.FlexParser;
import org.sonar.plugins.flex.FlexTokensVisitor;
import org.sonar.sslr.parser.LexerlessGrammar;
import org.sonarsource.analyzer.commons.ProgressReport;

public class FlexSquidSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(FlexSquidSensor.class);
    private final SonarRuntime sonarRuntime;
    private final Checks<FlexCheck> checks;
    private final FileLinesContextFactory fileLinesContextFactory;

    public FlexSquidSensor(SonarRuntime sonarRuntime, CheckFactory checkFactory, FileLinesContextFactory fileLinesContextFactory) {
        this.sonarRuntime = sonarRuntime;
        this.checks = checkFactory.create("flex").addAnnotatedChecks(CheckList.getChecks());
        this.fileLinesContextFactory = fileLinesContextFactory;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("Flex").onlyOnFileType(InputFile.Type.MAIN).onlyOnLanguage("flex");
        this.processesFilesIndependently(descriptor);
    }

    private void processesFilesIndependently(SensorDescriptor descriptor) {
        if (this.sonarRuntime.getProduct() == SonarProduct.SONARLINT || !this.sonarRuntime.getApiVersion().isGreaterThanOrEqual(Version.create((int)9, (int)3))) {
            return;
        }
        try {
            Method method = descriptor.getClass().getMethod("processesFilesIndependently", new Class[0]);
            method.invoke((Object)descriptor, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            LOG.warn("Could not call SensorDescriptor.processesFilesIndependently() method", (Throwable)e);
        }
    }

    public void execute(SensorContext context) {
        FileSystem fileSystem = context.fileSystem();
        FilePredicates predicates = fileSystem.predicates();
        FilePredicate filePredicate = predicates.and(new FilePredicate[]{predicates.hasType(InputFile.Type.MAIN), predicates.hasLanguage("flex"), inputFile -> !inputFile.uri().getPath().endsWith("mxml")});
        ArrayList inputFiles = new ArrayList();
        fileSystem.inputFiles(filePredicate).forEach(inputFiles::add);
        ProgressReport progressReport = new ProgressReport("Report about progress of the SonarSource Flex analyzer", TimeUnit.SECONDS.toMillis(10L));
        List<String> filenames = inputFiles.stream().map(InputFile::toString).collect(Collectors.toList());
        progressReport.start(filenames);
        for (InputFile inputFile2 : inputFiles) {
            this.analyseFile(context, inputFile2.charset(), inputFile2);
            progressReport.nextFile();
        }
        progressReport.stop();
    }

    private void analyseFile(SensorContext context, Charset charset, InputFile inputFile) {
        FlexVisitorContext visitorContext;
        String fileContent;
        try {
            fileContent = inputFile.contents();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot read " + inputFile, e);
        }
        Parser<LexerlessGrammar> parser = FlexParser.create(charset);
        try {
            visitorContext = new FlexVisitorContext(fileContent, parser.parse(fileContent));
            this.saveMeasures(context, inputFile, visitorContext);
        }
        catch (RecognitionException e) {
            visitorContext = new FlexVisitorContext(fileContent, e);
            LOG.error("Unable to parse file: {}", (Object)inputFile);
            LOG.error(e.getMessage());
        }
        for (FlexCheck check : this.checks.all()) {
            this.saveIssues(context, check, check.scanFileForIssues(visitorContext), inputFile);
        }
        new FlexTokensVisitor(context, FlexLexer.create(charset), inputFile).scanFile(visitorContext);
    }

    private void saveIssues(SensorContext context, FlexCheck check, List<Issue> issues, InputFile inputFile) {
        for (Issue flexIssue : issues) {
            Double cost;
            RuleKey ruleKey = this.checks.ruleKey((Object)check);
            NewIssue issue = context.newIssue();
            NewIssueLocation location = issue.newLocation().on((InputComponent)inputFile).message(flexIssue.message());
            Integer line = flexIssue.line();
            if (line != null) {
                location.at(inputFile.selectLine(line.intValue()));
            }
            if ((cost = flexIssue.cost()) != null) {
                issue.gap(cost);
            }
            issue.at(location).forRule(Objects.requireNonNull(ruleKey)).save();
        }
    }

    private void saveMeasures(SensorContext context, InputFile inputFile, FlexVisitorContext visitorContext) {
        FileMetrics metrics = new FileMetrics(visitorContext);
        FlexSquidSensor.saveMeasure(context, inputFile, (org.sonar.api.measures.Metric<Integer>)CoreMetrics.NCLOC, metrics.linesOfCode().size());
        FlexSquidSensor.saveMeasure(context, inputFile, (org.sonar.api.measures.Metric<Integer>)CoreMetrics.COMMENT_LINES, metrics.commentLines().size());
        FlexSquidSensor.saveMeasure(context, inputFile, (org.sonar.api.measures.Metric<Integer>)CoreMetrics.CLASSES, metrics.numberOfClasses());
        FlexSquidSensor.saveMeasure(context, inputFile, (org.sonar.api.measures.Metric<Integer>)CoreMetrics.FUNCTIONS, metrics.numberOfFunctions());
        FlexSquidSensor.saveMeasure(context, inputFile, (org.sonar.api.measures.Metric<Integer>)CoreMetrics.STATEMENTS, metrics.numberOfStatements());
        context.newMeasure().on((InputComponent)inputFile).forMetric((Metric)CoreMetrics.EXECUTABLE_LINES_DATA).withValue((Serializable)((Object)metrics.executableLines())).save();
        FileLinesContext fileLinesContext = this.fileLinesContextFactory.createFor(inputFile);
        metrics.linesOfCode().forEach(line -> fileLinesContext.setIntValue("ncloc_data", line.intValue(), 1));
        fileLinesContext.save();
        AstNode root = visitorContext.rootTree();
        int fileComplexity = ComplexityVisitor.complexity(Objects.requireNonNull(root));
        FlexSquidSensor.saveMeasure(context, inputFile, (org.sonar.api.measures.Metric<Integer>)CoreMetrics.COMPLEXITY, fileComplexity);
    }

    private static void saveMeasure(SensorContext context, InputFile inputFile, org.sonar.api.measures.Metric<Integer> metric, int value) {
        context.newMeasure().on((InputComponent)inputFile).forMetric(metric).withValue((Serializable)Integer.valueOf(value)).save();
    }
}

