/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.Decorator;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.quickfix.IssueWithQuickFix;
import org.sonar.python.quickfix.PythonQuickFix;
import org.sonar.python.quickfix.PythonTextEdit;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S2710")
public class ClassMethodFirstArgumentNameCheck
extends PythonSubscriptionCheck {
    private static final String DEFAULT_CLASS_PARAMETER_NAMES = "cls,mcs,metacls";
    private static final List<String> DEFAULT_CLASS_METHODS = Arrays.asList("__init_subclass__", "__class_getitem__", "__new__");
    List<String> classParameterNamesList;
    @RuleProperty(key="classParameterNames", description="Comma separated list of valid class parameter names", defaultValue="cls,mcs,metacls")
    public String classParameterNames = "cls,mcs,metacls";

    private List<String> classParameterNames() {
        if (this.classParameterNamesList == null) {
            this.classParameterNamesList = Stream.of(this.classParameterNames.split(",")).map(String::trim).collect(Collectors.toList());
        }
        return this.classParameterNamesList;
    }

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef functionDef = (FunctionDef)ctx.syntaxNode();
            if (!functionDef.isMethodDefinition()) {
                return;
            }
            if (DEFAULT_CLASS_METHODS.contains(functionDef.name().name())) {
                this.checkFirstParameterName(functionDef, (SubscriptionContext)ctx);
                return;
            }
            for (Decorator decorator : functionDef.decorators()) {
                String decoratorName = TreeUtils.decoratorNameFromExpression(decorator.expression());
                if (!"classmethod".equals(decoratorName)) continue;
                this.checkFirstParameterName(functionDef, (SubscriptionContext)ctx);
            }
        });
    }

    private void checkFirstParameterName(FunctionDef functionDef, SubscriptionContext ctx) {
        ParameterList parameterList = functionDef.parameters();
        if (parameterList == null || !parameterList.all().get(0).is(Tree.Kind.PARAMETER)) {
            return;
        }
        Parameter parameter = (Parameter)parameterList.all().get(0);
        Name parameterName = parameter.name();
        if (parameterName == null || parameter.starToken() != null) {
            return;
        }
        if (!this.classParameterNames().contains(parameterName.name())) {
            IssueWithQuickFix issue = (IssueWithQuickFix)ctx.addIssue(parameterName, String.format("Rename \"%s\" to a valid class parameter name or add the missing class parameter.", parameterName.name()));
            issue.addQuickFix(this.addClsAsTheFirstArgument(parameterName));
            issue.addQuickFix(this.renameTheFirstArgument(parameterName));
        }
    }

    private PythonQuickFix addClsAsTheFirstArgument(Name parameterName) {
        PythonTextEdit text;
        String newName = this.newName();
        if (ClassMethodFirstArgumentNameCheck.isSecondArgInNewLine(parameterName)) {
            int indent = ClassMethodFirstArgumentNameCheck.secondArgIndent(parameterName);
            text = PythonTextEdit.insertBefore(parameterName, newName + ",\n" + " ".repeat(indent));
        } else {
            text = PythonTextEdit.insertBefore(parameterName, newName + ", ");
        }
        return PythonQuickFix.newQuickFix(String.format("Add '%s' as the first argument.", newName)).addTextEdit(text).build();
    }

    private static boolean isSecondArgInNewLine(Name parameterName) {
        List<Tree> parameterListChildren = parameterName.parent().parent().children();
        if (parameterListChildren.size() >= 2) {
            Tree secondArg = parameterListChildren.get(2);
            return parameterName.firstToken().line() != secondArg.firstToken().line();
        }
        return false;
    }

    private static int secondArgIndent(Name parameterName) {
        List<Tree> parameterListChildren = parameterName.parent().parent().children();
        Tree secondArg = parameterListChildren.get(2);
        return secondArg.firstToken().column();
    }

    private PythonQuickFix renameTheFirstArgument(Name parameterName) {
        String newName = this.newName();
        return PythonQuickFix.newQuickFix(String.format("Rename '%s' to '%s'", parameterName.name(), newName)).addTextEdit(PythonTextEdit.renameAllUsages(parameterName, newName)).build();
    }

    private String newName() {
        return this.classParameterNames().get(0).isEmpty() ? "cls" : this.classParameterNames().get(0);
    }
}

