/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.python.checks.cdk.AbstractCdkResourceCheck;
import org.sonar.python.checks.cdk.CdkPredicate;
import org.sonar.python.checks.cdk.CdkUtils;

@Rule(key="S6332")
public class DisabledEFSEncryptionCheck
extends AbstractCdkResourceCheck {
    private static final String MESSAGE = "Make sure that using unencrypted file systems is safe here.";
    private static final String OMITTING_MESSAGE = "Omitting \"encrypted\" disables EFS encryption. Make sure it is safe here.";

    @Override
    protected void registerFqnConsumer() {
        this.checkFqn("aws_cdk.aws_efs.FileSystem", (ctx, fileSystem) -> CdkUtils.getArgument(ctx, fileSystem, "encrypted").ifPresent(encrypted -> encrypted.addIssueIf(CdkPredicate.isFalse(), MESSAGE, new IssueLocation[0])));
        this.checkFqn("aws_cdk.aws_efs.CfnFileSystem", (ctx, fileSystem) -> CdkUtils.getArgument(ctx, fileSystem, "encrypted").ifPresentOrElse(encrypted -> encrypted.addIssueIf(CdkPredicate.isFalse().or(CdkPredicate.isNone()), MESSAGE, new IssueLocation[0]), () -> ctx.addIssue(fileSystem.callee(), OMITTING_MESSAGE)));
    }
}

