/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.Collections;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.DictionaryLiteral;
import org.sonar.plugins.python.api.tree.DictionaryLiteralElement;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.KeyValuePair;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.cdk.AbstractCdkResourceCheck;
import org.sonar.python.checks.cdk.CdkPredicate;
import org.sonar.python.checks.cdk.CdkUtils;

@Rule(key="S6308")
public class DisabledESDomainEncryptionCheck
extends AbstractCdkResourceCheck {
    private static final String OMITTING_MESSAGE = "Omitting %s causes encryption of data at rest to be disabled for this %s domain. Make sure it is safe here.";
    private static final String UNENCRYPTED_MESSAGE = "Make sure that using unencrypted %s domains is safe here.";
    private static final String ENABLED = "enabled";
    private static final String OPENSEARCH = "OpenSearch";
    private static final String ELASTICSEARCH = "Elasticsearch";

    @Override
    protected void registerFqnConsumer() {
        this.checkFqn("aws_cdk.aws_opensearchservice.Domain", DisabledESDomainEncryptionCheck.checkDomain("encryption_at_rest", "aws_cdk.aws_opensearchservice.EncryptionAtRestOptions", OPENSEARCH));
        this.checkFqn("aws_cdk.aws_opensearchservice.CfnDomain", DisabledESDomainEncryptionCheck.checkDomain("encryption_at_rest_options", "aws_cdk.aws_opensearchservice.CfnDomain.EncryptionAtRestOptionsProperty", OPENSEARCH));
        this.checkFqn("aws_cdk.aws_elasticsearch.Domain", DisabledESDomainEncryptionCheck.checkDomain("encryption_at_rest", "aws_cdk.aws_elasticsearch.EncryptionAtRestOptions", ELASTICSEARCH));
        this.checkFqn("aws_cdk.aws_elasticsearch.CfnDomain", DisabledESDomainEncryptionCheck.checkDomain("encryption_at_rest_options", "aws_cdk.aws_elasticsearch.CfnDomain.EncryptionAtRestOptionsProperty", ELASTICSEARCH));
    }

    private static BiConsumer<SubscriptionContext, CallExpression> checkDomain(String encryptionArgName, String argFqnMethod, String engine) {
        return (ctx, callExpression) -> CdkUtils.getArgument(ctx, callExpression, encryptionArgName).ifPresentOrElse(flow -> flow.addIssueIf(DisabledESDomainEncryptionCheck.isSensitiveOptionObj(ctx, argFqnMethod).or(DisabledESDomainEncryptionCheck.isSensitiveOptionDict(ctx)), DisabledESDomainEncryptionCheck.unencryptedMessage(engine), new IssueLocation[0]), () -> ctx.addIssue(callExpression.callee(), DisabledESDomainEncryptionCheck.omittingMessage(encryptionArgName, engine)));
    }

    private static String omittingMessage(String encryptionArgName, String engine) {
        return String.format(OMITTING_MESSAGE, encryptionArgName, engine);
    }

    private static String unencryptedMessage(String engine) {
        return String.format(UNENCRYPTED_MESSAGE, engine);
    }

    private static Predicate<Expression> isSensitiveOptionObj(SubscriptionContext ctx, String argFqnMethod) {
        return expression -> CdkUtils.getCall(expression, argFqnMethod).map(call -> CdkUtils.getArgument(ctx, call, ENABLED)).stream().anyMatch(enabled -> enabled.isEmpty() || enabled.filter(flow -> flow.hasExpression(CdkPredicate.isFalse())).isPresent());
    }

    private static Predicate<Expression> isSensitiveOptionDict(SubscriptionContext ctx) {
        return expression -> expression.is(Tree.Kind.DICTIONARY_LITERAL) && DisabledESDomainEncryptionCheck.asDictionaryKeyValuePairs(expression).filter(DisabledESDomainEncryptionCheck.isKey(ENABLED)).allMatch(DisabledESDomainEncryptionCheck.isValueFalse(ctx));
    }

    private static Stream<KeyValuePair> asDictionaryKeyValuePairs(Expression expression) {
        return DisabledESDomainEncryptionCheck.asDictionaryElements(expression).filter(element -> element.is(Tree.Kind.KEY_VALUE_PAIR)).map(KeyValuePair.class::cast);
    }

    private static Stream<DictionaryLiteralElement> asDictionaryElements(Expression expression) {
        return Optional.of(expression).filter(expr -> expr.is(Tree.Kind.DICTIONARY_LITERAL)).map(DictionaryLiteral.class::cast).map(DictionaryLiteral::elements).orElse(Collections.emptyList()).stream();
    }

    private static Predicate<KeyValuePair> isKey(String keyName) {
        return keyValuePair -> Optional.of(keyValuePair).map(KeyValuePair::key).filter(key -> key.is(Tree.Kind.STRING_LITERAL)).map(StringLiteral.class::cast).filter(string -> string.trimmedQuotesValue().equals(keyName)).isPresent();
    }

    private static Predicate<KeyValuePair> isValueFalse(SubscriptionContext ctx) {
        return keyValuePair -> CdkUtils.ExpressionFlow.build(ctx, keyValuePair.value()).hasExpression(CdkPredicate.isFalse());
    }
}

