/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.DictionaryLiteral;
import org.sonar.python.checks.cdk.CdkUtils;

public abstract class PolicyStatement {
    @Nullable
    CdkUtils.ExpressionFlow principals() {
        return this.getProperty(Properties.PRINCIPALS);
    }

    @Nullable
    CdkUtils.ExpressionFlow conditions() {
        return this.getProperty(Properties.CONDITIONS);
    }

    @Nullable
    CdkUtils.ExpressionFlow effect() {
        return this.getProperty(Properties.EFFECT);
    }

    @Nullable
    CdkUtils.ExpressionFlow actions() {
        return this.getProperty(Properties.ACTIONS);
    }

    @Nullable
    CdkUtils.ExpressionFlow resources() {
        return this.getProperty(Properties.RESOURCES);
    }

    @Nullable
    protected abstract CdkUtils.ExpressionFlow getProperty(Properties var1);

    public static PolicyStatement build(SubscriptionContext ctx, CallExpression call) {
        return new PolicyStatementFromConstructor(ctx, call);
    }

    public static PolicyStatement build(SubscriptionContext ctx, DictionaryLiteral json) {
        return new PolicyStatementFromJson(CdkUtils.resolveDictionary(ctx, json));
    }

    private static class PolicyStatementFromJson
    extends PolicyStatement {
        final List<CdkUtils.ResolvedKeyValuePair> pairs;

        private PolicyStatementFromJson(List<CdkUtils.ResolvedKeyValuePair> pairs) {
            this.pairs = pairs;
        }

        @Override
        protected CdkUtils.ExpressionFlow getProperty(Properties property) {
            return CdkUtils.getDictionaryValue(this.pairs, property.jsonKey).orElse(null);
        }
    }

    private static class PolicyStatementFromConstructor
    extends PolicyStatement {
        final SubscriptionContext ctx;
        final CallExpression call;

        public PolicyStatementFromConstructor(SubscriptionContext ctx, CallExpression call) {
            this.ctx = ctx;
            this.call = call;
        }

        @Override
        protected CdkUtils.ExpressionFlow getProperty(Properties property) {
            return CdkUtils.getArgument(this.ctx, this.call, property.constructorKey).orElse(null);
        }
    }

    static enum Properties {
        PRINCIPALS("principals", "Principal"),
        CONDITIONS("conditions", "Condition"),
        EFFECT("effect", "Effect"),
        ACTIONS("actions", "Action"),
        RESOURCES("resources", "Resource");

        private final String constructorKey;
        private final String jsonKey;

        private Properties(String constructorKey, String jsonKey) {
            this.constructorKey = constructorKey;
            this.jsonKey = jsonKey;
        }
    }
}

