/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.python.checks.cdk.AbstractCdkResourceCheck;
import org.sonar.python.checks.cdk.CdkPredicate;
import org.sonar.python.checks.cdk.CdkUtils;

@Rule(key="S6463")
public class UnrestrictedOutboundCommunicationsCheck
extends AbstractCdkResourceCheck {
    public static final String OMITTING_MESSAGE = "Omitting \"allow_all_outbound\" enables unrestricted outbound communications. Make sure it is safe here.";
    public static final String UNRESTRICTED_MESSAGE = "Make sure that allowing unrestricted outbound communications is safe here.";

    @Override
    protected void registerFqnConsumer() {
        this.checkFqns(List.of("aws_cdk.aws_ec2.SecurityGroup", "aws_cdk.aws_ec2.SecurityGroup.from_security_group_id"), (subscriptionContext, callExpression) -> CdkUtils.getArgument(subscriptionContext, callExpression, "allow_all_outbound").ifPresentOrElse(argument -> argument.addIssueIf(CdkPredicate.isTrue(), UNRESTRICTED_MESSAGE, new IssueLocation[0]), () -> subscriptionContext.addIssue(callExpression.callee(), OMITTING_MESSAGE)));
    }
}

