/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.quickfix;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;

public class PythonTextEdit {
    private final String message;
    private final int startLine;
    private final int startLineOffset;
    private final int endLine;
    private final int endLineOffset;

    public PythonTextEdit(String message, int startLine, int startLineOffset, int endLine, int endLineOffset) {
        this.message = message;
        this.startLine = startLine;
        this.startLineOffset = startLineOffset;
        this.endLine = endLine;
        this.endLineOffset = endLineOffset;
    }

    public static PythonTextEdit insertLineBefore(Tree tree, String textToInsert) {
        String lineOffset = PythonTextEdit.offset(tree);
        textToInsert = (String)textToInsert + "\n";
        String textWithOffset = ((String)textToInsert).replace("\n", "\n" + lineOffset);
        return PythonTextEdit.insertBefore(tree, textWithOffset);
    }

    public static PythonTextEdit insertLineAfter(Tree tree, Tree indentReference, String textToInsert) {
        String lineOffset = PythonTextEdit.offset(indentReference);
        String textWithOffset = "\n" + lineOffset + textToInsert.replace("\n", "\n" + lineOffset);
        return PythonTextEdit.insertAfter(tree, textWithOffset);
    }

    private static String offset(Tree referenceTree) {
        return " ".repeat(referenceTree.firstToken().column());
    }

    public static PythonTextEdit insertBefore(Tree tree, String textToInsert) {
        Token token = tree.firstToken();
        return PythonTextEdit.insertAtPosition(token.line(), token.column(), textToInsert);
    }

    public static PythonTextEdit insertAfter(Tree tree, String textToInsert) {
        Token token = tree.firstToken();
        int lengthToken = token.value().length();
        return PythonTextEdit.insertAtPosition(token.line(), token.column() + lengthToken, textToInsert);
    }

    public static PythonTextEdit insertAtPosition(int line, int column, String textToInsert) {
        return new PythonTextEdit(textToInsert, line, column, line, column);
    }

    public static PythonTextEdit replace(Tree toReplace, String replacementText) {
        return PythonTextEdit.replaceRange(toReplace, toReplace, replacementText);
    }

    public static PythonTextEdit replaceRange(Tree start, Tree end, String replacementText) {
        Token first = start.firstToken();
        Token last = end.lastToken();
        return new PythonTextEdit(replacementText, first.line(), first.column(), last.line(), last.column() + last.value().length());
    }

    public static List<PythonTextEdit> shiftLeft(StatementList statementList) {
        int offset = statementList.firstToken().column() - statementList.parent().firstToken().column();
        return statementList.statements().stream().map(statement -> PythonTextEdit.shiftLeft(statement, offset)).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    private static List<PythonTextEdit> shiftLeft(Tree tree, int offset) {
        return TreeUtils.tokens(tree).stream().filter(token -> token.column() >= offset).map(Token::line).distinct().map(line -> PythonTextEdit.removeRange(line, 0, line, offset)).collect(Collectors.toList());
    }

    public static PythonTextEdit removeRange(int startLine, int startColumn, int endLine, int endColumn) {
        return new PythonTextEdit("", startLine, startColumn, endLine, endColumn);
    }

    public static PythonTextEdit removeUntil(Tree start, Tree until) {
        return PythonTextEdit.removeRange(start.firstToken().line(), start.firstToken().column(), until.firstToken().line(), until.firstToken().column());
    }

    public static PythonTextEdit removeStatement(Statement statement) {
        boolean hasNextSiblingOnLine;
        Tree next;
        Token firstTokenOfStmt = statement.firstToken();
        Token lastTokenOfStmt = TreeUtils.getTreeSeparatorOrLastToken(statement);
        List<Tree> siblings = statement.parent().children();
        int indexOfTree = siblings.indexOf(statement);
        Tree previous = indexOfTree > 0 ? siblings.get(indexOfTree - 1) : null;
        Tree tree = next = indexOfTree < siblings.size() - 1 ? siblings.get(indexOfTree + 1) : null;
        if (previous == null && next == null) {
            return PythonTextEdit.replace(statement, "pass");
        }
        boolean hasPreviousSiblingOnLine = previous != null && firstTokenOfStmt.line() == TreeUtils.getTreeSeparatorOrLastToken(previous.lastToken()).line();
        boolean bl = hasNextSiblingOnLine = next != null && lastTokenOfStmt.line() == next.firstToken().line();
        if (hasNextSiblingOnLine) {
            Token firstNextToken = next.firstToken();
            return PythonTextEdit.removeRange(firstTokenOfStmt.line(), firstTokenOfStmt.column(), firstNextToken.line(), firstNextToken.column());
        }
        if (hasPreviousSiblingOnLine) {
            Token lastPreviousToken = TreeUtils.getTreeSeparatorOrLastToken(previous);
            return PythonTextEdit.removeRange(lastPreviousToken.line(), PythonTextEdit.getEndColumn(lastPreviousToken), lastPreviousToken.line(), PythonTextEdit.getEndColumn(lastTokenOfStmt) - 1);
        }
        return PythonTextEdit.removeRange(firstTokenOfStmt.line(), 0, lastTokenOfStmt.line(), PythonTextEdit.getEndColumn(lastTokenOfStmt));
    }

    private static int getEndColumn(Token token) {
        return token.column() + token.value().length();
    }

    public static PythonTextEdit remove(Tree toRemove) {
        return PythonTextEdit.replace(toRemove, "");
    }

    public static List<PythonTextEdit> renameAllUsages(HasSymbol node, String newName) {
        Symbol symbol = node.symbol();
        List<Object> usages = symbol != null ? symbol.usages() : Collections.emptyList();
        LinkedList<PythonTextEdit> result = new LinkedList<PythonTextEdit>();
        for (Usage usage : usages) {
            PythonTextEdit text = PythonTextEdit.replace(usage.tree().firstToken(), newName);
            result.add(text);
        }
        return result;
    }

    public String replacementText() {
        return this.message;
    }

    public int startLine() {
        return this.startLine;
    }

    public int startLineOffset() {
        return this.startLineOffset;
    }

    public int endLine() {
        return this.endLine;
    }

    public int endLineOffset() {
        return this.endLineOffset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PythonTextEdit that = (PythonTextEdit)o;
        return this.startLine == that.startLine && this.startLineOffset == that.startLineOffset && this.endLine == that.endLine && this.endLineOffset == that.endLineOffset && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.startLine, this.startLineOffset, this.endLine, this.endLineOffset);
    }

    public String toString() {
        return "PythonTextEdit{message='" + this.message + "', startLine=" + this.startLine + ", startLineOffset=" + this.startLineOffset + ", endLine=" + this.endLine + ", endLineOffset=" + this.endLineOffset + "}";
    }
}

