/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.finders;

import java.util.Collections;
import java.util.regex.Pattern;
import org.sonarsource.analyzer.commons.regex.RegexIssueReporter;
import org.sonarsource.analyzer.commons.regex.ast.CharacterClassElementTree;
import org.sonarsource.analyzer.commons.regex.ast.CharacterClassTree;
import org.sonarsource.analyzer.commons.regex.ast.CharacterClassUnionTree;
import org.sonarsource.analyzer.commons.regex.ast.EscapedCharacterClassTree;
import org.sonarsource.analyzer.commons.regex.ast.Quantifier;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RepetitionTree;

public class VerboseRegexFinder
extends RegexBaseVisitor {
    private static final String VERBOSE_QUANTIFIER_MESSAGE = "Use concise quantifier syntax '%s' instead of '%s'.";
    private static final String VERBOSE_CHARACTER_CLASS_MESSAGE = "Use concise character class syntax '%s' instead of '%s'.";
    private final RegexIssueReporter.ElementIssue regexElementIssueReporter;

    public VerboseRegexFinder(RegexIssueReporter.ElementIssue regexElementIssueReporter) {
        this.regexElementIssueReporter = regexElementIssueReporter;
    }

    @Override
    public void visitCharacterClass(CharacterClassTree tree) {
        this.checkBulkyAlphaNumericCharacterClass(tree);
        this.checkBulkyNumericCharacterClass(tree);
        this.checkBulkyAnyCharacterClass(tree);
        super.visitCharacterClass(tree);
    }

    @Override
    public void visitRepetition(RepetitionTree tree) {
        this.checkBulkyQuantifier(tree.getQuantifier());
        super.visitRepetition(tree);
    }

    private void checkBulkyAlphaNumericCharacterClass(CharacterClassTree tree) {
        CharacterClassElementTree element = tree.getContents();
        if (element.is(CharacterClassElementTree.Kind.UNION) && ((CharacterClassUnionTree)element).getCharacterClasses().size() == 4) {
            boolean hasDigit = false;
            boolean hasLowerCase = false;
            boolean hasUpperCase = false;
            boolean hasUnderscore = false;
            for (CharacterClassElementTree subElement : ((CharacterClassUnionTree)element).getCharacterClasses()) {
                String raw = subElement.getText();
                if (subElement.is(CharacterClassElementTree.Kind.CHARACTER_RANGE)) {
                    hasDigit |= "0-9".equals(raw);
                    hasLowerCase |= "a-z".equals(raw);
                    hasUpperCase |= "A-Z".equals(raw);
                    continue;
                }
                if (!subElement.is(CharacterClassElementTree.Kind.PLAIN_CHARACTER)) continue;
                hasUnderscore |= "_".equals(raw);
            }
            if (hasDigit && hasLowerCase && hasUpperCase && hasUnderscore) {
                String expected = VerboseRegexFinder.backslash(tree) + (tree.isNegated() ? "W" : "w");
                this.reportVerboseCharacterClass(expected, tree);
            }
        }
    }

    private void checkBulkyNumericCharacterClass(CharacterClassTree tree) {
        CharacterClassElementTree element = tree.getContents();
        if (element.is(CharacterClassElementTree.Kind.CHARACTER_RANGE) && "0-9".equals(element.getText())) {
            String expected = VerboseRegexFinder.backslash(tree) + (tree.isNegated() ? "D" : "d");
            this.reportVerboseCharacterClass(expected, tree);
        }
    }

    private void checkBulkyAnyCharacterClass(CharacterClassTree tree) {
        boolean isBulkyAnyCharacterClass;
        CharacterClassElementTree element = tree.getContents();
        if (tree.isNegated() || !element.is(CharacterClassElementTree.Kind.UNION) || ((CharacterClassUnionTree)element).getCharacterClasses().size() != 2) {
            return;
        }
        boolean hasLowerEscapeW = false;
        boolean hasUpperEscapeW = false;
        boolean hasLowerEscapeD = false;
        boolean hasUpperEscapeD = false;
        boolean hasLowerEscapeS = false;
        boolean hasUpperEscapeS = false;
        for (CharacterClassElementTree subElement : ((CharacterClassUnionTree)element).getCharacterClasses()) {
            if (!subElement.is(CharacterClassElementTree.Kind.ESCAPED_CHARACTER_CLASS)) continue;
            char type = ((EscapedCharacterClassTree)subElement).getType();
            hasLowerEscapeW |= 'w' == type;
            hasUpperEscapeW |= 'W' == type;
            hasLowerEscapeD |= 'd' == type;
            hasUpperEscapeD |= 'D' == type;
            hasLowerEscapeS |= 's' == type;
            hasUpperEscapeS |= 'S' == type;
        }
        boolean bl = isBulkyAnyCharacterClass = hasLowerEscapeW && hasUpperEscapeW || hasLowerEscapeD && hasUpperEscapeD || hasLowerEscapeS && hasUpperEscapeS && tree.activeFlags().contains(32);
        if (isBulkyAnyCharacterClass) {
            this.reportVerboseCharacterClass(".", tree);
        }
    }

    private void reportVerboseCharacterClass(String expected, CharacterClassTree tree) {
        String message = String.format(VERBOSE_CHARACTER_CLASS_MESSAGE, expected, tree.getText());
        this.regexElementIssueReporter.report(tree, message, null, Collections.emptyList());
    }

    private void checkBulkyQuantifier(Quantifier quantifier) {
        String raw = quantifier.getText();
        BulkyQuantifier bulkyQuantifier = null;
        if (Pattern.matches("\\{0,1}\\??$", raw)) {
            bulkyQuantifier = new BulkyQuantifier("?", "{0,1}");
        } else if (Pattern.matches("\\{0,}\\??", raw)) {
            bulkyQuantifier = new BulkyQuantifier("*", "{0,}");
        } else if (Pattern.matches("\\{1,}\\??$", raw)) {
            bulkyQuantifier = new BulkyQuantifier("+", "{1,}");
        } else if (Pattern.matches("\\{(\\d+),\\1}\\??$", raw)) {
            int min = quantifier.getMinimumRepetitions();
            bulkyQuantifier = new BulkyQuantifier(String.format("{%d}", min), String.format("{%d,%d}", min, min));
        }
        if (bulkyQuantifier != null) {
            this.regexElementIssueReporter.report(quantifier, bulkyQuantifier.getMessage(), null, Collections.emptyList());
        }
    }

    private static class BulkyQuantifier {
        private final String concise;
        private final String verbose;

        protected BulkyQuantifier(String concise, String verbose) {
            this.concise = concise;
            this.verbose = verbose;
        }

        protected String getMessage() {
            return String.format(VerboseRegexFinder.VERBOSE_QUANTIFIER_MESSAGE, this.concise, this.verbose);
        }
    }
}

