/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.repositories.get;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesRequest;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetRepositoriesAction
extends TransportMasterNodeReadAction<GetRepositoriesRequest, GetRepositoriesResponse> {
    public static final String ALL_PATTERN = "_all";

    @Inject
    public TransportGetRepositoriesAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/repository/get", transportService, clusterService, threadPool, actionFilters, GetRepositoriesRequest::new, indexNameExpressionResolver, GetRepositoriesResponse::new, "same");
    }

    public static boolean isMatchAll(String[] patterns) {
        return patterns.length == 0 || patterns.length == 1 && (ALL_PATTERN.equalsIgnoreCase(patterns[0]) || Regex.isMatchAllPattern(patterns[0]));
    }

    @Override
    protected ClusterBlockException checkBlock(GetRepositoriesRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected void masterOperation(GetRepositoriesRequest request, ClusterState state, ActionListener<GetRepositoriesResponse> listener) {
        listener.onResponse(new GetRepositoriesResponse(new RepositoriesMetadata(TransportGetRepositoriesAction.getRepositories(state, request.repositories()))));
    }

    public static List<RepositoryMetadata> getRepositories(ClusterState state, String[] repoNames) {
        RepositoriesMetadata repositories = state.metadata().custom("repositories", RepositoriesMetadata.EMPTY);
        if (TransportGetRepositoriesAction.isMatchAll(repoNames)) {
            return repositories.repositories();
        }
        ArrayList<String> includePatterns = new ArrayList<String>();
        ArrayList<String> excludePatterns = new ArrayList<String>();
        boolean seenWildcard = false;
        for (String repositoryOrPattern : repoNames) {
            if (seenWildcard && repositoryOrPattern.length() > 1 && repositoryOrPattern.startsWith("-")) {
                excludePatterns.add(repositoryOrPattern.substring(1));
                continue;
            }
            if (Regex.isSimpleMatchPattern(repositoryOrPattern)) {
                seenWildcard = true;
            } else if (repositories.repository(repositoryOrPattern) == null) {
                throw new RepositoryMissingException(repositoryOrPattern);
            }
            includePatterns.add(repositoryOrPattern);
        }
        String[] excludes = excludePatterns.toArray(Strings.EMPTY_ARRAY);
        LinkedHashSet<RepositoryMetadata> repositoryListBuilder = new LinkedHashSet<RepositoryMetadata>();
        for (String repositoryOrPattern : includePatterns) {
            for (RepositoryMetadata repository : repositories.repositories()) {
                if (repositoryListBuilder.contains(repository) || !Regex.simpleMatch(repositoryOrPattern, repository.name()) || Regex.simpleMatch(excludes, repository.name())) continue;
                repositoryListBuilder.add(repository);
            }
        }
        return org.elasticsearch.core.List.copyOf(repositoryListBuilder);
    }
}

