/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.query.SpanQueryBuilder;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class SpanOrQueryBuilder
extends AbstractQueryBuilder<SpanOrQueryBuilder>
implements SpanQueryBuilder {
    public static final String NAME = "span_or";
    private static final ParseField CLAUSES_FIELD = new ParseField("clauses", new String[0]);
    private final List<SpanQueryBuilder> clauses = new ArrayList<SpanQueryBuilder>();

    public SpanOrQueryBuilder(SpanQueryBuilder initialClause) {
        if (initialClause == null) {
            throw new IllegalArgumentException("[span_or] must include at least one clause");
        }
        this.clauses.add(initialClause);
    }

    public SpanOrQueryBuilder(StreamInput in) throws IOException {
        super(in);
        for (QueryBuilder clause : SpanOrQueryBuilder.readQueries(in)) {
            this.clauses.add((SpanQueryBuilder)clause);
        }
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        SpanOrQueryBuilder.writeQueries(out, this.clauses);
    }

    public SpanOrQueryBuilder addClause(SpanQueryBuilder clause) {
        if (clause == null) {
            throw new IllegalArgumentException("[span_or] inner clause cannot be null");
        }
        this.clauses.add(clause);
        return this;
    }

    public List<SpanQueryBuilder> clauses() {
        return Collections.unmodifiableList(this.clauses);
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startArray(CLAUSES_FIELD.getPreferredName());
        for (SpanQueryBuilder clause : this.clauses) {
            clause.toXContent(builder, params);
        }
        builder.endArray();
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static SpanOrQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        float boost = 1.0f;
        String queryName = null;
        ArrayList<SpanQueryBuilder> clauses = new ArrayList<SpanQueryBuilder>();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (CLAUSES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        QueryBuilder query = SpanOrQueryBuilder.parseInnerQueryBuilder(parser);
                        if (!(query instanceof SpanQueryBuilder)) {
                            throw new ParsingException(parser.getTokenLocation(), "span_or [clauses] must be of type span query", new Object[0]);
                        }
                        SpanQueryBuilder clause = (SpanQueryBuilder)query;
                        SpanQueryBuilder.SpanQueryBuilderUtil.checkNoBoost(NAME, currentFieldName, parser, clause);
                        clauses.add(clause);
                    }
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[span_or] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                boost = parser.floatValue();
                continue;
            }
            if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                queryName = parser.text();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "[span_or] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (clauses.isEmpty()) {
            throw new ParsingException(parser.getTokenLocation(), "span_or must include [clauses]", new Object[0]);
        }
        SpanOrQueryBuilder queryBuilder = new SpanOrQueryBuilder((SpanQueryBuilder)clauses.get(0));
        for (int i = 1; i < clauses.size(); ++i) {
            queryBuilder.addClause((SpanQueryBuilder)clauses.get(i));
        }
        queryBuilder.boost(boost);
        queryBuilder.queryName(queryName);
        return queryBuilder;
    }

    @Override
    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        SpanQuery[] spanQueries = new SpanQuery[this.clauses.size()];
        for (int i = 0; i < this.clauses.size(); ++i) {
            Query query = this.clauses.get(i).toQuery(context);
            assert (query instanceof SpanQuery);
            spanQueries[i] = (SpanQuery)query;
        }
        return new SpanOrQuery(spanQueries);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.clauses);
    }

    @Override
    protected boolean doEquals(SpanOrQueryBuilder other) {
        return Objects.equals(this.clauses, other.clauses);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

