/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.future;

import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public interface WaitableFuture {
    public Object getId();

    default public boolean await() throws IOException {
        return this.await(Long.MAX_VALUE);
    }

    default public boolean await(long timeout2, TimeUnit unit) throws IOException {
        return this.await(unit.toMillis(timeout2));
    }

    default public boolean await(Duration timeout2) throws IOException {
        return timeout2 != null ? this.await(timeout2.toMillis()) : this.await();
    }

    public boolean await(long var1) throws IOException;

    default public boolean awaitUninterruptibly() {
        return this.awaitUninterruptibly(Long.MAX_VALUE);
    }

    default public boolean awaitUninterruptibly(long timeout2, TimeUnit unit) {
        return this.awaitUninterruptibly(unit.toMillis(timeout2));
    }

    default public boolean awaitUninterruptibly(Duration timeoutMillis) {
        return timeoutMillis != null ? this.awaitUninterruptibly(timeoutMillis.toMillis()) : this.awaitUninterruptibly();
    }

    public boolean awaitUninterruptibly(long var1);

    public boolean isDone();
}

