/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Ref;

public class RefSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String WILDCARD_SUFFIX = "/*";
    private boolean force;
    private boolean wildcard;
    private boolean matching;
    private boolean negative;
    private WildcardMode allowMismatchedWildcards;
    private String srcName;
    private String dstName;

    public static boolean isWildcard(String s) {
        return s != null && s.contains("*");
    }

    public RefSpec() {
        this.matching = false;
        this.force = false;
        this.wildcard = false;
        this.srcName = "HEAD";
        this.dstName = null;
        this.negative = false;
        this.allowMismatchedWildcards = WildcardMode.REQUIRE_MATCH;
    }

    public RefSpec(String spec, WildcardMode mode) {
        this.allowMismatchedWildcards = mode;
        String s = spec;
        if (s.startsWith("^+") || s.startsWith("+^")) {
            throw new IllegalArgumentException(JGitText.get().invalidNegativeAndForce);
        }
        if (s.startsWith("+")) {
            this.force = true;
            s = s.substring(1);
        }
        if (s.startsWith("^")) {
            this.negative = true;
            s = s.substring(1);
        }
        boolean matchPushSpec = false;
        int c = s.lastIndexOf(58);
        if (c == 0) {
            if ((s = s.substring(1)).isEmpty()) {
                matchPushSpec = true;
                this.wildcard = true;
                this.dstName = this.srcName = "refs/heads/*";
            } else {
                if (RefSpec.isWildcard(s)) {
                    this.wildcard = true;
                    if (mode == WildcardMode.REQUIRE_MATCH) {
                        throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidWildcards, spec));
                    }
                }
                this.dstName = RefSpec.checkValid(s);
            }
        } else if (c > 0) {
            String src = s.substring(0, c);
            String dst = s.substring(c + 1);
            if (RefSpec.isWildcard(src) && RefSpec.isWildcard(dst)) {
                this.wildcard = true;
            } else if (RefSpec.isWildcard(src) || RefSpec.isWildcard(dst)) {
                this.wildcard = true;
                if (mode == WildcardMode.REQUIRE_MATCH) {
                    throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidWildcards, spec));
                }
            }
            this.srcName = RefSpec.checkValid(src);
            this.dstName = RefSpec.checkValid(dst);
        } else {
            if (RefSpec.isWildcard(s)) {
                if (mode == WildcardMode.REQUIRE_MATCH) {
                    throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidWildcards, spec));
                }
                this.wildcard = true;
            }
            this.srcName = RefSpec.checkValid(s);
        }
        if (this.isNegative()) {
            if (RefSpec.isNullOrEmpty(this.srcName) && RefSpec.isNullOrEmpty(this.dstName)) {
                throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidRefSpec, spec));
            }
            if (!RefSpec.isNullOrEmpty(this.srcName) && !RefSpec.isNullOrEmpty(this.dstName)) {
                throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidRefSpec, spec));
            }
            if (this.wildcard && mode == WildcardMode.REQUIRE_MATCH) {
                throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidRefSpec, spec));
            }
        }
        this.matching = matchPushSpec;
    }

    public RefSpec(String spec) {
        this(spec, spec.startsWith("^") ? WildcardMode.ALLOW_MISMATCH : WildcardMode.REQUIRE_MATCH);
    }

    private RefSpec(RefSpec p) {
        this.matching = false;
        this.force = p.isForceUpdate();
        this.wildcard = p.isWildcard();
        this.negative = p.isNegative();
        this.srcName = p.getSource();
        this.dstName = p.getDestination();
        this.allowMismatchedWildcards = p.allowMismatchedWildcards;
    }

    public boolean isMatching() {
        return this.matching;
    }

    public boolean isForceUpdate() {
        return this.force;
    }

    public RefSpec setForceUpdate(boolean forceUpdate) {
        RefSpec r = new RefSpec(this);
        if (forceUpdate && this.isNegative()) {
            throw new IllegalArgumentException(JGitText.get().invalidNegativeAndForce);
        }
        r.matching = this.matching;
        r.force = forceUpdate;
        return r;
    }

    public boolean isWildcard() {
        return this.wildcard;
    }

    public boolean isNegative() {
        return this.negative;
    }

    public String getSource() {
        return this.srcName;
    }

    public RefSpec setSource(String source2) {
        RefSpec r = new RefSpec(this);
        r.srcName = RefSpec.checkValid(source2);
        if (RefSpec.isWildcard(r.srcName) && r.dstName == null) {
            throw new IllegalStateException(JGitText.get().destinationIsNotAWildcard);
        }
        if (RefSpec.isWildcard(r.srcName) != RefSpec.isWildcard(r.dstName)) {
            throw new IllegalStateException(JGitText.get().sourceDestinationMustMatch);
        }
        return r;
    }

    public String getDestination() {
        return this.dstName;
    }

    public RefSpec setDestination(String destination) {
        RefSpec r = new RefSpec(this);
        r.dstName = RefSpec.checkValid(destination);
        if (RefSpec.isWildcard(r.dstName) && r.srcName == null) {
            throw new IllegalStateException(JGitText.get().sourceIsNotAWildcard);
        }
        if (RefSpec.isWildcard(r.srcName) != RefSpec.isWildcard(r.dstName)) {
            throw new IllegalStateException(JGitText.get().sourceDestinationMustMatch);
        }
        return r;
    }

    public RefSpec setSourceDestination(String source2, String destination) {
        if (RefSpec.isWildcard(source2) != RefSpec.isWildcard(destination)) {
            throw new IllegalStateException(JGitText.get().sourceDestinationMustMatch);
        }
        RefSpec r = new RefSpec(this);
        r.wildcard = RefSpec.isWildcard(source2);
        r.srcName = source2;
        r.dstName = destination;
        return r;
    }

    public boolean matchSource(String r) {
        return this.match(r, this.getSource());
    }

    public boolean matchSource(Ref r) {
        return this.match(r.getName(), this.getSource());
    }

    public boolean matchDestination(String r) {
        return this.match(r, this.getDestination());
    }

    public boolean matchDestination(Ref r) {
        return this.match(r.getName(), this.getDestination());
    }

    public RefSpec expandFromSource(String r) {
        if (this.allowMismatchedWildcards != WildcardMode.REQUIRE_MATCH) {
            throw new IllegalStateException(JGitText.get().invalidExpandWildcard);
        }
        return this.isWildcard() ? new RefSpec(this).expandFromSourceImp(r) : this;
    }

    private RefSpec expandFromSourceImp(String name) {
        String psrc = this.srcName;
        String pdst = this.dstName;
        this.wildcard = false;
        this.srcName = name;
        this.dstName = RefSpec.expandWildcard(name, psrc, pdst);
        return this;
    }

    private static boolean isNullOrEmpty(String refName) {
        return refName == null || refName.isEmpty();
    }

    public RefSpec expandFromSource(Ref r) {
        return this.expandFromSource(r.getName());
    }

    public RefSpec expandFromDestination(String r) {
        if (this.allowMismatchedWildcards != WildcardMode.REQUIRE_MATCH) {
            throw new IllegalStateException(JGitText.get().invalidExpandWildcard);
        }
        return this.isWildcard() ? new RefSpec(this).expandFromDstImp(r) : this;
    }

    private RefSpec expandFromDstImp(String name) {
        String psrc = this.srcName;
        String pdst = this.dstName;
        this.wildcard = false;
        this.srcName = RefSpec.expandWildcard(name, pdst, psrc);
        this.dstName = name;
        return this;
    }

    public RefSpec expandFromDestination(Ref r) {
        return this.expandFromDestination(r.getName());
    }

    private boolean match(String name, String s) {
        if (s == null) {
            return false;
        }
        if (RefSpec.isWildcard(s)) {
            int wildcardIndex = s.indexOf(42);
            String prefix = s.substring(0, wildcardIndex);
            String suffix = s.substring(wildcardIndex + 1);
            return name.length() > prefix.length() + suffix.length() && name.startsWith(prefix) && name.endsWith(suffix);
        }
        return name.equals(s);
    }

    private static String expandWildcard(String name, String patternA, String patternB) {
        int a = patternA.indexOf(42);
        int trailingA = patternA.length() - (a + 1);
        int b = patternB.indexOf(42);
        String match = name.substring(a, name.length() - trailingA);
        return String.valueOf(patternB.substring(0, b)) + match + patternB.substring(b + 1);
    }

    private static String checkValid(String spec) {
        if (spec != null && !RefSpec.isValid(spec)) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidRefSpec, spec));
        }
        return spec;
    }

    private static boolean isValid(String s) {
        if (s.startsWith("/")) {
            return false;
        }
        if (s.contains("//")) {
            return false;
        }
        if (s.endsWith("/")) {
            return false;
        }
        int i = s.indexOf(42);
        return i == -1 || s.indexOf(42, i + 1) <= i;
    }

    public int hashCode() {
        int hc = 0;
        if (this.getSource() != null) {
            hc = hc * 31 + this.getSource().hashCode();
        }
        if (this.getDestination() != null) {
            hc = hc * 31 + this.getDestination().hashCode();
        }
        return hc;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RefSpec)) {
            return false;
        }
        RefSpec b = (RefSpec)obj;
        if (this.isForceUpdate() != b.isForceUpdate()) {
            return false;
        }
        if (this.isNegative() != b.isNegative()) {
            return false;
        }
        if (this.isMatching()) {
            return b.isMatching();
        }
        if (b.isMatching()) {
            return false;
        }
        return this.isWildcard() == b.isWildcard() && Objects.equals(this.getSource(), b.getSource()) && Objects.equals(this.getDestination(), b.getDestination());
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        if (this.isForceUpdate()) {
            r.append('+');
        }
        if (this.isNegative()) {
            r.append('^');
        }
        if (this.isMatching()) {
            r.append(':');
        } else {
            if (this.getSource() != null) {
                r.append(this.getSource());
            }
            if (this.getDestination() != null) {
                r.append(':');
                r.append(this.getDestination());
            }
        }
        return r.toString();
    }

    public static enum WildcardMode {
        REQUIRE_MATCH,
        ALLOW_MISMATCH;

    }
}

