/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.profiles;

import java.io.IOException;
import java.io.Writer;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.internal.apachecommons.lang.StringEscapeUtils;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.ActiveRuleParam;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.SonarException;

@Deprecated
@ServerSide
@ComputeEngineSide
public class XMLProfileSerializer {
    public void write(RulesProfile profile2, Writer writer) {
        try {
            XMLProfileSerializer.appendHeader(profile2, writer);
            XMLProfileSerializer.appendRules(profile2, writer);
            XMLProfileSerializer.appendFooter(writer);
        }
        catch (IOException e) {
            throw new SonarException("Fail to export the profile " + profile2, e);
        }
    }

    private static void appendHeader(RulesProfile profile2, Writer writer) throws IOException {
        writer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!-- Generated by SonarQube --><profile><name>");
        StringEscapeUtils.escapeXml(writer, profile2.getName());
        writer.append("</name><language>");
        StringEscapeUtils.escapeXml(writer, profile2.getLanguage());
        writer.append("</language>");
    }

    private static void appendRules(RulesProfile profile2, Writer writer) throws IOException {
        if (!profile2.getActiveRules().isEmpty()) {
            writer.append("<rules>");
            for (ActiveRule activeRule : profile2.getActiveRules()) {
                XMLProfileSerializer.appendRule(activeRule, writer);
            }
            writer.append("</rules>");
        }
    }

    private static void appendRule(ActiveRule activeRule, Writer writer) throws IOException {
        writer.append("<rule><repositoryKey>");
        writer.append(activeRule.getRepositoryKey());
        writer.append("</repositoryKey><key>");
        StringEscapeUtils.escapeXml(writer, activeRule.getRuleKey());
        writer.append("</key>");
        if (activeRule.getSeverity() != null) {
            writer.append("<priority>");
            writer.append(activeRule.getSeverity().name());
            writer.append("</priority>");
        }
        XMLProfileSerializer.appendRuleParameters(activeRule, writer);
        writer.append("</rule>");
    }

    private static void appendRuleParameters(ActiveRule activeRule, Writer writer) throws IOException {
        if (activeRule.getActiveRuleParams() != null && !activeRule.getActiveRuleParams().isEmpty()) {
            writer.append("<parameters>");
            for (ActiveRuleParam activeRuleParam : activeRule.getActiveRuleParams()) {
                XMLProfileSerializer.appendRuleParameter(writer, activeRuleParam);
            }
            writer.append("</parameters>");
        }
    }

    private static void appendRuleParameter(Writer writer, ActiveRuleParam activeRuleParam) throws IOException {
        if (StringUtils.isNotBlank(activeRuleParam.getValue())) {
            writer.append("<parameter><key>");
            StringEscapeUtils.escapeXml(writer, activeRuleParam.getKey());
            writer.append("</key><value>");
            StringEscapeUtils.escapeXml(writer, activeRuleParam.getValue());
            writer.append("</value>");
            writer.append("</parameter>");
        }
    }

    private static void appendFooter(Writer writer) throws IOException {
        writer.append("</profile>");
    }
}

