/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.config;

import java.util.Arrays;
import java.util.List;
import org.sonar.api.PropertyType;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.core.config.Frequency;

public final class PurgeProperties {
    public static final String DEFAULT_FREQUENCY = Frequency.MONTHLY.getDescription();

    private PurgeProperties() {
    }

    public static List<PropertyDefinition> all() {
        return Arrays.asList(PropertyDefinition.builder("sonar.dbcleaner.hoursBeforeKeepingOnlyOneSnapshotByDay").defaultValue("24").name("Keep only one analysis a day after").description("After this number of hours, if there are several analyses during the same day, the DbCleaner keeps the most recent one and fully deletes the other ones.").type(PropertyType.INTEGER).onQualifiers("TRK", new String[0]).category("housekeeping").subCategory("general").index(1).build(), PropertyDefinition.builder("sonar.dbcleaner.weeksBeforeKeepingOnlyOneSnapshotByWeek").defaultValue("4").name("Keep only one analysis a week after").description("After this number of weeks, if there are several analyses during the same week, the DbCleaner keeps the most recent one and fully deletes the other ones").type(PropertyType.INTEGER).onQualifiers("TRK", new String[0]).category("housekeeping").subCategory("general").index(2).build(), PropertyDefinition.builder("sonar.dbcleaner.weeksBeforeKeepingOnlyOneSnapshotByMonth").defaultValue("52").name("Keep only one analysis a month after").description("After this number of weeks, if there are several analyses during the same month, the DbCleaner keeps the most recent one and fully deletes the other ones.").type(PropertyType.INTEGER).onQualifiers("TRK", new String[0]).category("housekeeping").subCategory("general").index(3).build(), PropertyDefinition.builder("sonar.dbcleaner.weeksBeforeKeepingOnlyAnalysesWithVersion").defaultValue("104").name("Keep only analyses with a version event after").description("After this number of weeks, the DbCleaner keeps only analyses with a version event associated.").type(PropertyType.INTEGER).onQualifiers("TRK", new String[0]).category("housekeeping").subCategory("general").index(4).build(), PropertyDefinition.builder("sonar.dbcleaner.weeksBeforeDeletingAllSnapshots").defaultValue("260").name("Delete all analyses after").description("After this number of weeks, all analyses are fully deleted.").type(PropertyType.INTEGER).onQualifiers("TRK", new String[0]).category("housekeeping").subCategory("general").index(5).build(), PropertyDefinition.builder("sonar.dbcleaner.daysBeforeDeletingClosedIssues").defaultValue("30").name("Delete closed issues after").description("Issues that have been closed for more than this number of days will be deleted.").type(PropertyType.INTEGER).onQualifiers("TRK", new String[0]).category("housekeeping").subCategory("general").index(6).build());
    }
}

