/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.platform;

import org.sonar.api.Startable;
import org.sonar.api.utils.log.Loggers;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.lang.Nullable;

public class StartableBeanPostProcessor
implements DestructionAwareBeanPostProcessor {
    @Override
    @Nullable
    public Object postProcessBeforeInitialization(Object bean2, String beanName) throws BeansException {
        if (bean2 instanceof Startable) {
            ((Startable)bean2).start();
        }
        return bean2;
    }

    @Override
    public boolean requiresDestruction(Object bean2) {
        return bean2 instanceof Startable;
    }

    @Override
    public void postProcessBeforeDestruction(Object bean2, String beanName) throws BeansException {
        try {
            if (bean2 instanceof Startable) {
                ((Startable)bean2).stop();
            }
        }
        catch (Exception e) {
            Loggers.get(StartableBeanPostProcessor.class).warn("Dispose of component {} failed", (Object)bean2.getClass().getCanonicalName(), (Object)e);
        }
    }
}

