/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.sarif;

import com.google.gson.annotations.SerializedName;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.core.sarif.CodeFlow;
import org.sonar.core.sarif.Location;
import org.sonar.core.sarif.PartialFingerprints;
import org.sonar.core.sarif.WrappedText;

public class Result {
    @SerializedName(value="ruleId")
    private final String ruleId;
    @SerializedName(value="message")
    private final WrappedText message;
    @SerializedName(value="locations")
    private final LinkedHashSet<Location> locations;
    @SerializedName(value="partialFingerprints")
    private final PartialFingerprints partialFingerprints;
    @SerializedName(value="codeFlows")
    private final List<CodeFlow> codeFlows;
    @SerializedName(value="level")
    private final String level;

    private Result(String ruleId, String message, LinkedHashSet<Location> locations, @Nullable String primaryLocationLineHash, @Nullable List<CodeFlow> codeFlows, @Nullable String level) {
        this.ruleId = ruleId;
        this.message = WrappedText.of(message);
        this.locations = locations;
        this.partialFingerprints = primaryLocationLineHash == null ? null : new PartialFingerprints(primaryLocationLineHash);
        this.codeFlows = codeFlows == null ? null : List.copyOf(codeFlows);
        this.level = level;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public WrappedText getMessage() {
        return this.message;
    }

    public Set<Location> getLocations() {
        return this.locations;
    }

    @CheckForNull
    public PartialFingerprints getPartialFingerprints() {
        return this.partialFingerprints;
    }

    @CheckForNull
    public List<CodeFlow> getCodeFlows() {
        return this.codeFlows;
    }

    public String getLevel() {
        return this.level;
    }

    public static ResultBuilder builder() {
        return new ResultBuilder();
    }

    public static final class ResultBuilder {
        private String ruleId;
        private String message;
        private LinkedHashSet<Location> locations;
        private String hash;
        private List<CodeFlow> codeFlows;
        private String level;

        private ResultBuilder() {
        }

        public ResultBuilder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public ResultBuilder message(String message) {
            this.message = message;
            return this;
        }

        public ResultBuilder level(String level) {
            this.level = level;
            return this;
        }

        public ResultBuilder locations(Set<Location> locations) {
            this.locations = new LinkedHashSet<Location>(locations);
            return this;
        }

        public ResultBuilder hash(String hash) {
            this.hash = hash;
            return this;
        }

        public ResultBuilder codeFlows(List<CodeFlow> codeFlows) {
            this.codeFlows = codeFlows;
            return this;
        }

        public Result build() {
            return new Result(this.ruleId, this.message, this.locations, this.hash, this.codeFlows, this.level);
        }
    }
}

