/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.sensor;

import java.util.List;
import java.util.stream.Collectors;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.logs.Profiler;
import org.sonar.scanner.bootstrap.ScannerPluginRepository;
import org.sonar.scanner.sensor.ExecutingSensorContext;
import org.sonar.scanner.sensor.ProjectSensorExtensionDictionary;
import org.sonar.scanner.sensor.ProjectSensorWrapper;
import org.sonar.scanner.sensor.SensorId;

public class ProjectSensorsExecutor {
    private static final Logger LOG = Loggers.get(ProjectSensorsExecutor.class);
    private static final Profiler profiler = Profiler.create(LOG);
    private final ProjectSensorExtensionDictionary selector;
    private final ScannerPluginRepository pluginRepo;
    private final ExecutingSensorContext executingSensorCtx;

    public ProjectSensorsExecutor(ProjectSensorExtensionDictionary selector, ScannerPluginRepository pluginRepo, ExecutingSensorContext executingSensorCtx) {
        this.selector = selector;
        this.pluginRepo = pluginRepo;
        this.executingSensorCtx = executingSensorCtx;
    }

    public void execute() {
        List<ProjectSensorWrapper> sensors = this.selector.selectSensors();
        LOG.debug("Sensors : {}", (Object)sensors.stream().map(Object::toString).collect(Collectors.joining(" -> ")));
        for (ProjectSensorWrapper sensor : sensors) {
            SensorId sensorId = this.getSensorId(sensor);
            this.executingSensorCtx.setSensorExecuting(sensorId);
            profiler.startInfo("Sensor " + sensorId);
            sensor.analyse();
            profiler.stopInfo();
            this.executingSensorCtx.clearExecutingSensor();
        }
    }

    private SensorId getSensorId(ProjectSensorWrapper sensor) {
        ClassLoader cl = ProjectSensorsExecutor.getSensorClassLoader(sensor);
        String pluginKey = this.pluginRepo.getPluginKey(cl);
        return new SensorId(pluginKey, sensor.toString());
    }

    private static ClassLoader getSensorClassLoader(ProjectSensorWrapper sensor) {
        return sensor.wrappedSensor().getClass().getClassLoader();
    }
}

