/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.sensor;

import java.util.Objects;
import java.util.Set;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.scanner.scan.branch.BranchConfiguration;
import org.sonar.scanner.sensor.ExecutingSensorContext;
import org.sonar.scanner.sensor.SensorId;

public class UnchangedFilesHandler {
    private static final Logger LOG = Loggers.get(UnchangedFilesHandler.class);
    private static final Set<SensorId> ENABLED_SENSORS = Set.of(new SensorId("cpp", "CFamily"), new SensorId("cobol", "CobolSquidSensor"), new SensorId("xoo", "Mark As Unchanged Sensor"));
    private static final String ENABLE_PROPERTY_KEY = "sonar.unchangedFiles.optimize";
    private final boolean featureActive;
    private final ExecutingSensorContext executingSensorContext;

    public UnchangedFilesHandler(Configuration configuration, BranchConfiguration branchConfiguration, ExecutingSensorContext executingSensorContext) {
        this.executingSensorContext = executingSensorContext;
        this.featureActive = UnchangedFilesHandler.getFeatureActivationStatus(configuration, branchConfiguration);
    }

    private static boolean getFeatureActivationStatus(Configuration configuration, BranchConfiguration branchConfiguration) {
        boolean isPropertyEnabled = configuration.getBoolean(ENABLE_PROPERTY_KEY).orElse(false);
        if (!isPropertyEnabled) {
            return false;
        }
        if (branchConfiguration.isPullRequest() || !Objects.equals(branchConfiguration.branchName(), branchConfiguration.referenceBranchName())) {
            LOG.debug("Optimization for unchanged files not enabled because it's not an analysis of a branch with a previous analysis");
            return false;
        }
        LOG.info("Optimization for unchanged files enabled");
        return true;
    }

    public void markAsUnchanged(DefaultInputFile file) {
        if (this.isFeatureActive()) {
            if (file.status() != InputFile.Status.SAME) {
                LOG.error("File '{}' was marked as unchanged but its status is {}", (Object)file.getProjectRelativePath(), (Object)file.status());
            } else {
                LOG.debug("File '{}' marked as unchanged", (Object)file.getProjectRelativePath());
                file.setMarkedAsUnchanged(true);
            }
        }
    }

    private boolean isFeatureActive() {
        return this.featureActive && this.executingSensorContext.getSensorExecuting() != null && ENABLED_SENSORS.contains(this.executingSensorContext.getSensorExecuting());
    }
}

