/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scm.svn;

import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ChangedLinesComputer {
    private final Tracker tracker;
    private final OutputStream receiver = new OutputStream(){
        StringBuilder sb = new StringBuilder();

        @Override
        public void write(int b) {
            this.sb.append((char)b);
            if (b == 10) {
                ChangedLinesComputer.this.tracker.parseLine(this.sb.toString());
                this.sb.setLength(0);
            }
        }
    };

    ChangedLinesComputer(Path rootBaseDir, Set<Path> included) {
        this.tracker = new Tracker(rootBaseDir, included);
    }

    OutputStream receiver() {
        return this.receiver;
    }

    Map<Path, Set<Integer>> changedLines() {
        return this.tracker.changedLines();
    }

    private static class Tracker {
        private static final Pattern START_LINE_IN_TARGET = Pattern.compile(" \\+(\\d+)");
        private static final String ENTRY_START_PREFIX = "Index: ";
        private final Map<Path, Set<Integer>> changedLines = new HashMap<Path, Set<Integer>>();
        private final Set<Path> included;
        private final Path rootBaseDir;
        private int lineNumInTarget;
        private Path currentPath = null;
        private int skipCount = 0;

        Tracker(Path rootBaseDir, Set<Path> included) {
            this.rootBaseDir = rootBaseDir;
            this.included = included;
        }

        private void parseLine(String line) {
            if (line.startsWith(ENTRY_START_PREFIX)) {
                this.currentPath = Paths.get(line.substring(ENTRY_START_PREFIX.length()).trim(), new String[0]);
                if (!this.currentPath.isAbsolute()) {
                    this.currentPath = this.rootBaseDir.resolve(this.currentPath);
                }
                if (!this.included.contains(this.currentPath)) {
                    return;
                }
                this.skipCount = 3;
                return;
            }
            if (!this.included.contains(this.currentPath)) {
                return;
            }
            if (this.skipCount > 0) {
                --this.skipCount;
                return;
            }
            if (line.startsWith("@@ ")) {
                Matcher matcher = START_LINE_IN_TARGET.matcher(line);
                if (!matcher.find()) {
                    throw new IllegalStateException("Invalid block header: " + line);
                }
                this.lineNumInTarget = Integer.parseInt(matcher.group(1));
                return;
            }
            this.parseContent(line);
        }

        private void parseContent(String line) {
            char firstChar = line.charAt(0);
            if (firstChar == ' ') {
                ++this.lineNumInTarget;
            } else if (firstChar == '+') {
                this.changedLines.computeIfAbsent(this.currentPath, path -> new HashSet()).add(this.lineNumInTarget);
                ++this.lineNumInTarget;
            }
        }

        Map<Path, Set<Integer>> changedLines() {
            return this.changedLines;
        }
    }
}

