/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.schema;

import org.tmatesoft.sqljet.core.schema.ISqlJetExpression;

public interface ISqlJetBinaryExpression
extends ISqlJetExpression {
    public Operation getOperation();

    public ISqlJetExpression getLeftExpression();

    public ISqlJetExpression getRightExpression();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        OR,
        AND,
        EQUALS,
        NOT_EQUALS,
        LESS,
        LESS_OR_EQ,
        GREATER,
        GREATER_OR_EQ,
        SHIFT_LEFT,
        SHIFT_RIGHT,
        BIT_AND,
        BIT_OR,
        PLUS,
        MINUS,
        MULTIPLY,
        DIVIDE,
        MODULO,
        CONCATENATE;


        public static Operation decode(String s) {
            if ("or".equalsIgnoreCase(s)) {
                return OR;
            }
            if ("and".equalsIgnoreCase(s)) {
                return AND;
            }
            if ("=".equalsIgnoreCase(s) || "==".equalsIgnoreCase(s)) {
                return EQUALS;
            }
            if ("!=".equalsIgnoreCase(s) || "<>".equalsIgnoreCase(s)) {
                return NOT_EQUALS;
            }
            if ("<".equalsIgnoreCase(s)) {
                return LESS;
            }
            if ("<=".equalsIgnoreCase(s)) {
                return LESS_OR_EQ;
            }
            if (">".equalsIgnoreCase(s)) {
                return GREATER;
            }
            if (">=".equalsIgnoreCase(s)) {
                return GREATER_OR_EQ;
            }
            if ("<<".equalsIgnoreCase(s)) {
                return SHIFT_LEFT;
            }
            if (">>".equalsIgnoreCase(s)) {
                return SHIFT_RIGHT;
            }
            if ("&".equalsIgnoreCase(s)) {
                return BIT_AND;
            }
            if ("|".equalsIgnoreCase(s)) {
                return BIT_OR;
            }
            if ("+".equalsIgnoreCase(s)) {
                return PLUS;
            }
            if ("-".equalsIgnoreCase(s)) {
                return MINUS;
            }
            if ("*".equalsIgnoreCase(s)) {
                return MULTIPLY;
            }
            if ("/".equalsIgnoreCase(s)) {
                return DIVIDE;
            }
            if ("%".equalsIgnoreCase(s)) {
                return MODULO;
            }
            if ("||".equalsIgnoreCase(s)) {
                return CONCATENATE;
            }
            return null;
        }

        public String toString() {
            switch (this) {
                case OR: {
                    return "OR";
                }
                case AND: {
                    return "AND";
                }
                case EQUALS: {
                    return "=";
                }
                case NOT_EQUALS: {
                    return "!=";
                }
                case LESS: {
                    return "<";
                }
                case LESS_OR_EQ: {
                    return "<=";
                }
                case GREATER: {
                    return ">";
                }
                case GREATER_OR_EQ: {
                    return ">=";
                }
                case SHIFT_LEFT: {
                    return "<<";
                }
                case SHIFT_RIGHT: {
                    return ">>";
                }
                case BIT_AND: {
                    return "&";
                }
                case BIT_OR: {
                    return "|";
                }
                case PLUS: {
                    return "+";
                }
                case MINUS: {
                    return "-";
                }
                case MULTIPLY: {
                    return "*";
                }
                case DIVIDE: {
                    return "/";
                }
                case MODULO: {
                    return "%";
                }
                case CONCATENATE: {
                    return "||";
                }
            }
            return "";
        }
    }
}

