/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

// StatusApplyConfiguration represents an declarative configuration of the Status type for use
// with apply.
type StatusApplyConfiguration struct {
	TypeMetaApplyConfiguration  `json:",inline"`
	*ListMetaApplyConfiguration `json:"metadata,omitempty"`
	Status                      *string                          `json:"status,omitempty"`
	Message                     *string                          `json:"message,omitempty"`
	Reason                      *metav1.StatusReason             `json:"reason,omitempty"`
	Details                     *StatusDetailsApplyConfiguration `json:"details,omitempty"`
	Code                        *int32                           `json:"code,omitempty"`
}

// StatusApplyConfiguration constructs an declarative configuration of the Status type for use with
// apply.
func Status() *StatusApplyConfiguration {
	b := &StatusApplyConfiguration{}
	b.WithKind("Status")
	b.WithAPIVersion("meta.k8s.io/v1")
	return b
}

// WithKind sets the Kind field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Kind field is set to the value of the last call.
func (b *StatusApplyConfiguration) WithKind(value string) *StatusApplyConfiguration {
	b.Kind = &value
	return b
}

// WithAPIVersion sets the APIVersion field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the APIVersion field is set to the value of the last call.
func (b *StatusApplyConfiguration) WithAPIVersion(value string) *StatusApplyConfiguration {
	b.APIVersion = &value
	return b
}

// WithSelfLink sets the SelfLink field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SelfLink field is set to the value of the last call.
func (b *StatusApplyConfiguration) WithSelfLink(value string) *StatusApplyConfiguration {
	b.ensureListMetaApplyConfigurationExists()
	b.SelfLink = &value
	return b
}

// WithResourceVersion sets the ResourceVersion field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ResourceVersion field is set to the value of the last call.
func (b *StatusApplyConfiguration) WithResourceVersion(value string) *StatusApplyConfiguration {
	b.ensureListMetaApplyConfigurationExists()
	b.ResourceVersion = &value
	return b
}

// WithContinue sets the Continue field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Continue field is set to the value of the last call.
func (b *StatusApplyConfiguration) WithContinue(value string) *StatusApplyConfiguration {
	b.ensureListMetaApplyConfigurationExists()
	b.Continue = &value
	return b
}

// WithRemainingItemCount sets the RemainingItemCount field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RemainingItemCount field is set to the value of the last call.
func (b *StatusApplyConfiguration) WithRemainingItemCount(value int64) *StatusApplyConfiguration {
	b.ensureListMetaApplyConfigurationExists()
	b.RemainingItemCount = &value
	return b
}

func (b *StatusApplyConfiguration) ensureListMetaApplyConfigurationExists() {
	if b.ListMetaApplyConfiguration == nil {
		b.ListMetaApplyConfiguration = &ListMetaApplyConfiguration{}
	}
}

// WithStatus sets the Status field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Status field is set to the value of the last call.
func (b *StatusApplyConfiguration) WithStatus(value string) *StatusApplyConfiguration {
	b.Status = &value
	return b
}

// WithMessage sets the Message field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Message field is set to the value of the last call.
func (b *StatusApplyConfiguration) WithMessage(value string) *StatusApplyConfiguration {
	b.Message = &value
	return b
}

// WithReason sets the Reason field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Reason field is set to the value of the last call.
func (b *StatusApplyConfiguration) WithReason(value metav1.StatusReason) *StatusApplyConfiguration {
	b.Reason = &value
	return b
}

// WithDetails sets the Details field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Details field is set to the value of the last call.
func (b *StatusApplyConfiguration) WithDetails(value *StatusDetailsApplyConfiguration) *StatusApplyConfiguration {
	b.Details = value
	return b
}

// WithCode sets the Code field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Code field is set to the value of the last call.
func (b *StatusApplyConfiguration) WithCode(value int32) *StatusApplyConfiguration {
	b.Code = &value
	return b
}
