/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rcm;

import com.alibaba.rcm.Constraint;
import java.util.Objects;

public class ResourceType {
    public static final ResourceType CPU_PERCENT = new ResourceType("CPU_PERCENT"){

        @Override
        protected void validate(long ... lArray) throws IllegalArgumentException {
            Objects.requireNonNull(lArray);
            if (lArray.length != 1 || lArray[0] < 1L || lArray[0] > (long)Runtime.getRuntime().availableProcessors() * 100L) {
                throw new IllegalArgumentException("Bad CPU_PERCENT constraint: " + lArray[0]);
            }
        }
    };
    public static final ResourceType HEAP_RETAINED = new ResourceType("HEAP_RETAINED"){

        @Override
        protected void validate(long ... lArray) throws IllegalArgumentException {
            Objects.requireNonNull(lArray);
            if (lArray.length != 1 || lArray[0] <= 0L || lArray[0] > Runtime.getRuntime().maxMemory()) {
                throw new IllegalArgumentException("Bad HEAP_RETAINED constraint: " + lArray[0]);
            }
        }
    };
    private final String name;

    protected ResourceType(String string) {
        this.name = string;
    }

    public Constraint newConstraint(long ... lArray) {
        this.validate(lArray);
        return new Constraint(this, lArray);
    }

    protected void validate(long ... lArray) throws IllegalArgumentException {
    }

    public String toString() {
        return "ResourceType-" + this.name;
    }
}

