﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using System;
using System.Collections.Immutable;

namespace Microsoft.CodeAnalysis.VisualBasic.ExpressionEvaluator
{
    internal sealed partial class MemberSignatureParser
    {
        // From SyntaxFacts.GetReservedKeywordKinds(). (See
        // VisualBasicParsingTests.Keywords() which verifies the lists are in sync.)
        private static ImmutableHashSet<string> GetKeywords(StringComparer comparer)
        {
            return ImmutableHashSet.CreateRange(
                comparer,
                new[]
                {
                    "AddressOf",
                    "AddHandler",
                    "Alias",
                    "And",
                    "AndAlso",
                    "As",
                    "Boolean",
                    "ByRef",
                    "Byte",
                    "ByVal",
                    "Call",
                    "Case",
                    "Catch",
                    "CBool",
                    "CByte",
                    "CChar",
                    "CDate",
                    "CDec",
                    "CDbl",
                    "Char",
                    "CInt",
                    "Class",
                    "CLng",
                    "CObj",
                    "Const",
                    "Continue",
                    "CSByte",
                    "CShort",
                    "CSng",
                    "CStr",
                    "CType",
                    "CUInt",
                    "CULng",
                    "CUShort",
                    "Date",
                    "Decimal",
                    "Declare",
                    "Default",
                    "Delegate",
                    "Dim",
                    "DirectCast",
                    "Do",
                    "Double",
                    "Each",
                    "Else",
                    "ElseIf",
                    "End",
                    "Enum",
                    "Erase",
                    "Error",
                    "Event",
                    "Exit",
                    "False",
                    "Finally",
                    "For",
                    "Friend",
                    "Function",
                    "Get",
                    "GetType",
                    "GetXmlNamespace",
                    "Global",
                    "GoTo",
                    "Handles",
                    "If",
                    "Implements",
                    "Imports",
                    "In",
                    "Inherits",
                    "Integer",
                    "Interface",
                    "Is",
                    "IsNot",
                    "Let",
                    "Lib",
                    "Like",
                    "Long",
                    "Loop",
                    "Me",
                    "Mod",
                    "Module",
                    "MustInherit",
                    "MustOverride",
                    "MyBase",
                    "MyClass",
                    "NameOf",
                    "Namespace",
                    "Narrowing",
                    "Next",
                    "New",
                    "Not",
                    "Nothing",
                    "NotInheritable",
                    "NotOverridable",
                    "Object",
                    "Of",
                    "On",
                    "Operator",
                    "Option",
                    "Optional",
                    "Or",
                    "OrElse",
                    "Overloads",
                    "Overridable",
                    "Overrides",
                    "ParamArray",
                    "Partial",
                    "Private",
                    "Property",
                    "Protected",
                    "Public",
                    "RaiseEvent",
                    "ReadOnly",
                    "ReDim",
                    "REM",
                    "RemoveHandler",
                    "Resume",
                    "Return",
                    "SByte",
                    "Select",
                    "Set",
                    "Shadows",
                    "Shared",
                    "Short",
                    "Single",
                    "Static",
                    "Step",
                    "Stop",
                    "String",
                    "Structure",
                    "Sub",
                    "SyncLock",
                    "Then",
                    "Throw",
                    "To",
                    "True",
                    "Try",
                    "TryCast",
                    "TypeOf",
                    "UInteger",
                    "ULong",
                    "UShort",
                    "Using",
                    "When",
                    "While",
                    "Widening",
                    "With",
                    "WithEvents",
                    "WriteOnly",
                    "Xor",
                    "EndIf",
                    "Gosub",
                    "Variant",
                    "Wend",
                });
        }
    }
}
